package com.elitesland.tw.tw5.api.prd.inv.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoiceTravelItineraryPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceTravelItineraryQuery;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceTravelItineraryVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 发票行程单
 *
 * @author zoey
 * @date 2023-12-05
 */
public interface InvInvoiceTravelItineraryService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link InvInvoiceTravelItineraryVO}>
     */
    PagingVO<InvInvoiceTravelItineraryVO> queryPaging(InvInvoiceTravelItineraryQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link InvInvoiceTravelItineraryVO}>
     */
    List<InvInvoiceTravelItineraryVO> queryListDynamic(InvInvoiceTravelItineraryQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link InvInvoiceTravelItineraryVO}
     */
    InvInvoiceTravelItineraryVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link InvInvoiceTravelItineraryVO}
     */
    InvInvoiceTravelItineraryVO insert(InvInvoiceTravelItineraryPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link InvInvoiceTravelItineraryVO}
     */
    InvInvoiceTravelItineraryVO update(InvInvoiceTravelItineraryPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(InvInvoiceTravelItineraryPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
