package com.elitesland.tw.tw5.api.prd.my.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 远程办公审批配置
 *
 * @author wangly
 * @date 2024-06-13
 */
@Getter
@Setter
public class AbnormalWorkApplyConfigPayload extends TwCommonPayload  implements Serializable {
    /** 事由类型 */
    @ApiModelProperty("事由类型")
    private String reasonType;
    /** 触发条件 */
    @ApiModelProperty("触发条件")
    private String triggerCondition;
    /** 触发天数 */
    @ApiModelProperty("触发天数")
    private BigDecimal conditionDays;
    /** 业务角色1 */
    @ApiModelProperty("业务角色1")
    private String firstRoleType;
    /** 审批角色1 */
    @ApiModelProperty("审批角色1")
    private String firstApprovePerson;
    /** 业务角色2 */
    @ApiModelProperty("业务角色2")
    private String twiceRoleType;
    /** 审批角色2 */
    @ApiModelProperty("审批角色2")
    private String twiceApprovePerson;
    /** 业务角色3 */
    @ApiModelProperty("业务角色3")
    private String thirdRoleType;
    /** 审批角色3 */
    @ApiModelProperty("审批角色3")
    private String thirdApprovePerson;
    /** 业务角色4 */
    @ApiModelProperty("业务角色4")
    private String fourthRoleType;
    /** 审批角色4 */
    @ApiModelProperty("审批角色4")
    private String fourthApprovePerson;
    /** 扩展字段1 */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /** 扩展字段2 */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /** 扩展字段3 */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /** 扩展字段4 */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /** 扩展字段5 */
    @ApiModelProperty("扩展字段5")
    private String ext5;
}
