package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;

@Getter
@Setter
public class TAttendanceRecordQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 打卡人员ID 精确
     */
    @ApiModelProperty("打卡人员ID")
    private Long attendanceResId;
    /**
     * 打卡日期 精确
     */
    @ApiModelProperty("打卡日期")
    private LocalDate attendanceDate;
    /**
     * 规则ID 精确
     */
    @ApiModelProperty("规则ID")
    private Long attendanceRuleId;
    /**
     * 上班时间 精确
     */
    @ApiModelProperty("上班时间")
    private String attendanceTimeStart;
    /**
     * 下班时间 精确
     */
    @ApiModelProperty("下班时间")
    private String attendanceTimeEnd;
    /**
     * 打卡结果 YSE/NO 精确
     */
    @ApiModelProperty("打卡结果 YSE/NO")
    private String attendanceResult;
    /**
     * 正常、迟到或早退、矿工 精确
     */
    @ApiModelProperty("正常、迟到或早退、矿工")
    private String attendanceResultDetail;
    /**
     * 特殊打卡原因 精确
     */
    @ApiModelProperty("特殊打卡原因")
    private String specialReason;
    /**
     * 打卡设备 精确
     */
    @ApiModelProperty("打卡设备")
    private String attendanceDevice;
}

