package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanTempListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanTempPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetPlanTempQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetPlanTempVO;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 工作计划模板
 *
 * @author duwh
 * @date 2022-12-14
 */
public interface PmsTimesheetPlanTempService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TimesheetPlanTempVO}>
     */
    PagingVO<TimesheetPlanTempVO> paging(TimesheetPlanTempQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TimesheetPlanTempVO}>
     */
    List<TimesheetPlanTempVO> queryList(TimesheetPlanTempQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TimesheetPlanTempVO}
     */
    TimesheetPlanTempVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TimesheetPlanTempVO}
     */
    TimesheetPlanTempVO insert(TimesheetPlanTempPayload payload);

    /**
     * 批量插入
     *
     * @param payload 有效载荷
     * @return {@link List}<{@link TimesheetPlanTempVO}>
     */
    List<TimesheetPlanTempVO> batchInsert(TimesheetPlanTempListPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TimesheetPlanTempVO}
     */
    TimesheetPlanTempVO update(TimesheetPlanTempPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * Excel导出数据
     *
     * @param all      待导出的数据
     * @param response /
     * @throws IOException /
     */
    void download(List<TimesheetPlanTempVO> all, HttpServletResponse response) throws IOException;


}
