package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.UserVacationApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationApplyDetailVO;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationApplyVO;

import java.util.List;

/**
 * @author sunxw
 * @description 用户假期申请
 * @Date 2023/5/9
 */
public interface UserVacationApplyService {

    /**
     * 分页
     *
     * @param query 查询参数
     * @return {@link PagingVO}<{@link UserVacationApplyVO}>
     */
    PagingVO<UserVacationApplyVO> paging(UserVacationApplyQuery query);

    /**
     * list查询
     *
     * @param query 查询参数
     * @return {@link PagingVO}<{@link UserVacationApplyVO}>
     */
    List<UserVacationApplyVO> list(UserVacationApplyQuery query);

    List<UserVacationApplyVO> queryList(UserVacationApplyQuery query);

    /**
     * 请假申请数据同步
     *
     * @param param
     */
    @Deprecated
    void syncVacationApplyData(String param);

    /**
     * 请假申请明细数据同步
     *
     * @param param
     */
    @Deprecated
    void syncVacationApplyDetailData(String param);

    /**
     * 根据请假申请id获取明细
     *
     * @param applyId 用户申请表的key
     * @return
     */
    List<UserVacationApplyDetailVO> getDetailByApplyKey(Long applyId);


    /**
     * 员工请假申请
     *
     * @param payload
     * @return
     */
    void userVacationApply(UserVacationApplyPayload payload);

    /**
     * 根据流程id查询申请信息
     *
     * @param procId
     * @return
     */
    UserVacationApplyVO queryApply(String procId);

    /**
     * 根据流程id查询申请信息
     *
     * @param businessKey
     * @return
     */
    UserVacationApplyVO queryApplyByKey(String businessKey);

    /**
     * 员工请假新增
     *
     * @param payload
     * @return
     */

    UserVacationApplyVO userVacationInsert(UserVacationApplyPayload payload);

    /**
     * 员工请假更新
     *
     * @param payload
     * @return
     */

    UserVacationApplyVO userVacationUpdate(UserVacationApplyPayload payload);

}
