package com.elitesland.tw.tw5.api.prd.partner.common.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 公司主体-证件信息
 *
 * @author wangly
 * @date 2023-05-29
 */
@Getter
@Setter
public class BookLicensePayload extends TwCommonPayload  implements Serializable {
    /** 地址薄id */
    @ApiModelProperty("地址薄id")
    private Long bookId;
    /** 证件编号 */
    @ApiModelProperty("证件编号")
    private String licenseNo;
    /** 证件类型 */
    @ApiModelProperty("证件类型")
    private String licenseType;
    /** 证件状态 udc[CRM:COMPANY:LICENSE_STATUS] */
    @ApiModelProperty("证件状态 udc[CRM:COMPANY:LICENSE_STATUS]")
    private String licenseStatus;
    /** 失效日期 */
    @ApiModelProperty("失效日期")
    private LocalDate invalidDate;
    /** 附件 */
    @ApiModelProperty("附件")
    private String fileCode;
    /** 排序号 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 扩展字段1 */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /** 扩展字段2 */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /** 扩展字段3 */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /** 扩展字段4 */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /** 扩展字段5 */
    @ApiModelProperty("扩展字段5")
    private String ext5;
}
