package com.elitesland.tw.tw5.api.prd.partner.common.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 业务伙伴管理
 *
 * @author wangluyu
 * @date 2023-05-16
 */
@Getter
@Setter
public class BusinessPartnerVO extends BaseViewModel implements Serializable {
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;

    @ApiModelProperty("唯一识别号")
    private String idenNo;

    /**
     * 记录创建者
     */
    @ApiModelProperty("记录创建者")
    @UdcName(udcName = "USER", codePropName = "createUserId")
    private String creatUserName;

    /**
     * 地址簿id 用来和银行账户 基本信息 地址信息等关联
     */
    @ApiModelProperty("地址簿id 用来和银行账户 基本信息 地址信息等关联")
    private Long bookId;

    @ApiModelProperty("tw4.0地址簿id")
    private Long bookIdV4;

    /**
     * 业务伙伴编号
     */
    @ApiModelProperty("业务伙伴编号")
    private String businessPartnerNo;

    /**
     * 客户编号
     */
    @ApiModelProperty("客户编号")
    private String customerNo;
    /**
     * 类型 udc[CRM:BUSINESS_PARTNER:TYPE]
     */
    @ApiModelProperty("类型 udc[CRM:BUSINESS_PARTNER:TYPE]")
    private String partnerType;
    /**
     * 类型 udc[CRM:BUSINESS_PARTNER:TYPE]
     */
    @ApiModelProperty("类型描述 udc[CRM:BUSINESS_PARTNER:TYPE]")
    @UdcName(udcName = "CRM:BUSINESS_PARTNER:TYPE", codePropName = "partnerType")
    private String partnerTypeDesc;

    /**
     * 业务伙伴名称
     */
    @ApiModelProperty("业务伙伴名称")
    private String partnerName;
    /**
     * 业务伙伴名称
     */
    @ApiModelProperty("业务伙伴名称拼音")
    private String partnerNamePinyin;
    /**
     * 业务伙伴身份 udc[CRM:BUSINESS_PARTNER:IDENTITY]
     */
    @ApiModelProperty("业务伙伴身份 udc[CRM:BUSINESS_PARTNER:IDENTITY]")
    private String partnerIdentity;
    /**
     * 业务伙伴身份 udc[CRM:BUSINESS_PARTNER:IDENTITY]
     */
    @ApiModelProperty("业务伙伴身份描述 udc[CRM:BUSINESS_PARTNER:IDENTITY]")
    private String partnerIdentityDesc;
    /**
     * 行业 udc[crm:leads_customer_industry]
     */
    @ApiModelProperty("行业 udc[crm:leads_customer_industry]")
    private String partnerIndustry;
    /**
     * 行业 udc[crm:leads_customer_industry]
     */

    @ApiModelProperty("行业描述 udc[crm:leads_customer_industry]")
    @UdcName(udcName = "crm:leads_customer_industry", codePropName = "partnerIndustry")
    private String partnerIndustryDesc;

    /**
     * 性质 udc[crm:company_nature]
     */
    @ApiModelProperty("性质 udc[crm:company_nature]")
    private String partnerNature;

    /**
     * 性质 udc[crm:company_nature]
     */
    @ApiModelProperty("性质描述 udc[crm:company_nature]")
    @UdcName(udcName = "crm:company_nature", codePropName = "partnerNature")
    private String partnerNatureDesc;

    /**
     * 组织规模 udc[crm:customer_scale]
     */
    @ApiModelProperty("组织规模 udc[crm:customer_scale]")
    private String organizationScale;

    /**
     * 组织规模 udc[crm:customer_scale]
     */
    @ApiModelProperty("组织规模描述 udc[crm:customer_scale]")
    @UdcName(udcName = "crm:customer_scale", codePropName = "organizationScale")
    private String organizationScaleDesc;
    /**
     * 网址
     */
    @ApiModelProperty("网址")
    private String partnerWebsite;
    /**
     * 邮箱
     */
    @ApiModelProperty("邮箱")
    private String partnerEmail;
    /**
     * 传真
     */
    @ApiModelProperty("传真")
    private String partnerFax;
    /**
     * 电话
     */
    @ApiModelProperty("电话")
    private String partnerPhone;
    /**
     * 主交易货币  udc[SYSTEM_BASIC:CURRENCY]
     */
    @ApiModelProperty("主交易货币  udc[SYSTEM_BASIC:CURRENCY]")
    private String currency;

    /**
     * 主交易货币  udc[SYSTEM_BASIC:CURRENCY]
     */
    @ApiModelProperty("主交易货币  udc[SYSTEM_BASIC:CURRENCY]")
    @UdcName(udcName = "SYSTEM_BASIC:CURRENCY", codePropName = "currency")
    private String currencyDesc;
    /**
     * 主要语言
     */
    @ApiModelProperty("主要语言")
    private String language;
    /**
     * 主要语言
     */
    @ApiModelProperty("主要语言")
    @UdcName(udcName = "SYSTEM_BASIC:LANGUAGE", codePropName = "language")
    private String languageDesc;

    /****个人类型  起****/

    /**
     * 英文名称
     */
    @ApiModelProperty("英文名称")
    private String englishName;

    /**
     * 证件类型
     */
    @ApiModelProperty("个人证件类型 udc[CRM:BUSINESS_PARTNER:CERTIFICATE_TYPE]")
    private String certificateType;

    /**
     * 证件类型
     */
    @ApiModelProperty("个人证件类型 udc[CRM:BUSINESS_PARTNER:CERTIFICATE_TYPE]")
    @UdcName(udcName = "CRM:BUSINESS_PARTNER:CERTIFICATE_TYPE", codePropName = "certificateType")
    private String certificateTypeDesc;

    /**
     * 证件号
     */
    @ApiModelProperty("证件号")
    private String certificateNo;

    /**
     * 性别 udc[org:employee:sex]
     */
    @ApiModelProperty("性别 udc[org:employee:sex]")
    private String partnerSex;

    /**
     * 性别 udc[org:employee:sex]
     */
    @ApiModelProperty("性别 udc[org:employee:sex]")
    @UdcName(udcName = "org:employee:sex", codePropName = "partnerSex")
    private String partnerSexDesc;

    /**
     * 生日
     */
    @ApiModelProperty("生日")
    private String partnerBirthday;

    /**
     * 国籍
     */
    @ApiModelProperty("国籍 udc[SYSTEM_BASIC:COUNTRY]")
    private String nationality;

    @ApiModelProperty("国籍 udc[SYSTEM_BASIC:COUNTRY]")
    @UdcName(udcName = "SYSTEM_BASIC:COUNTRY", codePropName = "nationality")
    private String nationalityDesc;


    /**
     * 籍贯
     */
    @ApiModelProperty("籍贯")
    private String nativePlace;

    /**
     * 民族
     */
    @ApiModelProperty("民族")
    private String nation;

    /**
     * 婚姻状况
     */
    @ApiModelProperty("婚姻状况 udc[CRM:BUSINESS_PARTNER:MARITAL_STATUS]")
    private String maritalStatus;

    /**
     * 婚姻状况
     */
    @ApiModelProperty("婚姻状况 udc[CRM:BUSINESS_PARTNER:MARITAL_STATUS]")
    @UdcName(udcName = "CRM:BUSINESS_PARTNER:MARITAL_STATUS", codePropName = "maritalStatus")
    private String maritalStatusDesc;

    /**
     * 证件有效期
     */
    @ApiModelProperty("证件有效期起")
    private LocalDate certificateDateStart;

    /**
     * 证件有效期
     */
    @ApiModelProperty("证件有效期止")
    private LocalDate certificateDateEnd;

    /**
     * 联系人手机
     */
    @ApiModelProperty("联系人手机")
    private String contactsPhone;

    /**
     * 联系人邮箱
     */
    @ApiModelProperty("联系人邮箱")
    private String contactsEmail;


    /****个人类型  止****/


    /**
     * 业务伙伴区域
     */
    @ApiModelProperty("业务伙伴区域 udc[crm:customer_region]")
    private String partnerRegion;

    /**
     * 业务伙伴区域
     */
    @ApiModelProperty("业务伙伴区域 udc[crm:customer_region]")
    @UdcName(udcName = "crm:customer_region", codePropName = "partnerRegion")
    private String partnerRegionDesc;
//    /** 附件 */
//    @ApiModelProperty("附件")
//    private String fileCodes;
    /**
     * 排序号
     */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /**
     * 拓展字段1
     */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /**
     * 拓展字段2
     */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /**
     * 拓展字段3
     */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /**
     * 拓展字段4
     */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /**
     * 拓展字段5
     */
    @ApiModelProperty("拓展字段5")
    private String ext5;
    /**
     * 母公司ID
     */
    @ApiModelProperty("母公司ID")
    private Long parentId;
    /**
     * 母公司名称
     */
    @ApiModelProperty("母公司名称")
    private String parentIdDesc;
    /**
     * 国家
     */
    @ApiModelProperty("国家")
    private String country;
    /**
     * 省
     */
    @ApiModelProperty("省")
    private String province;
    /**
     * 市
     */
    @ApiModelProperty("市")
    private String city;
    /**
     * 区
     */
    @ApiModelProperty("区")
    private String district;
    /**
     * 详细地址
     */
    @ApiModelProperty("详细地址")
    private String detailAddress;
    /**
     * 省
     */
    @ApiModelProperty("省")
    private String provinceName;
    /**
     * 市
     */
    @ApiModelProperty("市")
    private String cityName;
    /**
     * 区
     */
    @ApiModelProperty("区")
    private String districtName;

    @ApiModelProperty("省市区")
    private String address;

    /**
     * 销售负责人Id
     */
    @ApiModelProperty("销售负责人Id")
    private String saleDutyId;

    /**
     * 销售负责人名字
     */
    @ApiModelProperty("销售负责人名字")
    private String saleDutyIdDesc;

    /**
     * 客户id
     */
    @ApiModelProperty("客户id")
    private Long formalCustomerId;

    /**
     * 经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标
     */
    @ApiModelProperty("经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标")
    private String longitudeLatitude;

    /**
     * 客户状态
     */
    @ApiModelProperty("客户状态")
    private String customerStatus;

    /**
     * 客户状态 udc[CRM:BUSINESS_PARTNER:STATUS]
     */
    @ApiModelProperty("客户状态 udc[CRM:BUSINESS_PARTNER:STATUS]")
    @UdcName(udcName = "CRM:BUSINESS_PARTNER:STATUS", codePropName = "customerStatus")
    private String customerStatusDesc;

    /**
     * 客户级别 udc[crm:customer_grade]
     */
    @ApiModelProperty("客户级别 udc[crm:customer_grade]")
    private String customerGradle;

    @ApiModelProperty("客户级别 udc[crm:customer_grade]")
    @UdcName(udcName = "crm:customer_grade", codePropName = "customerGradle")
    private String customerGradleDesc;

    @ApiModelProperty("客戶id")
    private Long businessCustomerInfoId;

    /**
     * 合作伙伴状态
     */
    @ApiModelProperty("合作伙伴状态")
    private String collaborateStatus;

    /**
     * 合作伙伴状态
     */
    @ApiModelProperty("合作伙伴状态")
    @UdcName(udcName = "CRM:BUSINESS_PARTNER:STATUS", codePropName = "collaborateStatus")
    private String collaborateStatusDesc;

    /**
     * 供应商状态
     */
    @ApiModelProperty("供应商状态")
    private String supplierStatus;

    /**
     * 供应商状态
     */
    @ApiModelProperty("供应商状态")
    @UdcName(udcName = "CRM:BUSINESS_PARTNER:STATUS", codePropName = "supplierStatus")
    private String supplierStatusDesc;

    @ApiModelProperty("供应商id")
    private Long businessSupplierInfoId;

    @ApiModelProperty("供应商JDE编号")
    private String supplierNo;
    /**
     * 第三方系统编号
     */
    @ApiModelProperty("第三方系统编号")
    private String thirdSystemNo;

    /**
     * 是否有客户身份
     */
    @ApiModelProperty("是否有客户身份 ")
    private Boolean customerFlag;

    /**
     * 是否有供应商身份
     */
    @ApiModelProperty("是否有供应商身份 ")
    private Boolean supplierFlag;

    /**
     * 是否有合作伙伴身份
     */
    @ApiModelProperty(value = "是否有合作伙伴身份")
    private Boolean collaborateFlag;

    //流程字段
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String applyStatus;
    /**
     * 内部/外部
     */
    @ApiModelProperty("内部/外部 udc[CRM:BUSINESS_PARTNER:INSIDE_OR_OUTSIDE]")
    private String insideOrOutSide;

    /**
     * 内部/外部
     */
    @ApiModelProperty("内部/外部")
    @UdcName(udcName = "CRM:BUSINESS_PARTNER:INSIDE_OR_OUTSIDE", codePropName = "insideOrOutSide")
    private String insideOrOutSideDesc;

    /**
     * 待确认潜在客户
     */
    @ApiModelProperty("待确认潜在客户")
    private Boolean confirmFlag;

    /**
     * 客户经营状态
     */
    @ApiModelProperty("客户经营状态")
    private String custOperStatus;

    /**
     * 客户经营id
     */
    @ApiModelProperty("客户经营id")
    private Long operId;

    /**
     * 服务负责人
     */
    @ApiModelProperty("服务负责人")
    private Long serviceUserId;

    /**
     * 服务负责人
     */
    @ApiModelProperty("服务负责人")
    private String serviceUserName;

    /**
     * 商务负责人
     */
    @ApiModelProperty("商务负责人")
    private Long businessUserId;

    /**
     * 商务负责人
     */
    @ApiModelProperty("商务负责人")
    private String businessUserName;

    /**
     * 关怀负责人
     */
    @ApiModelProperty("关怀负责人")
    private Long careUserId;

    /**
     * 关怀负责人
     */
    @ApiModelProperty("关怀负责人")
    private String careUserName;

    /**
     * 运维售后负责人
     */
    @ApiModelProperty("运维售后负责人")
    private Long operationUserId;

    /**
     * 运维售后负责人
     */
    @ApiModelProperty("运维售后负责人")
    private String operationUserName;


    /**
     * 潜在客户负责人标志(1是 0否)
     */
    @ApiModelProperty("潜在客户负责人标志")
    private Boolean confirmCustFlag;

    /**
     * 是否有业务伙伴财务负责人角色
     */
    @ApiModelProperty("是否有财务成员角色角色")
    private Boolean businessFinancePicFlag;

    /**
     * 是否有当前客户客户经营权限
     */
    @ApiModelProperty("是否有当前客户客户经营权限")
    private Boolean businessOperaPermissonFlag;

    @ApiModelProperty("jde公司编号")
    private String jdeCompanyNo;


    /**
     * 同步客户标志
     */
    @ApiModelProperty("同步客户标志")
    private Boolean syncJdeFlag;

    @ApiModelProperty("上级主管部门")
    private String parentManageBU;
}
