package com.elitesland.tw.tw5.api.prd.partner.strategy.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessModelIndexSettingPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessModelIndexSettingQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessModelIndexSettingVO;

import java.util.List;

/**
 * 分级策略模型指标配置
 *
 * @author wangly
 * @date 2023-06-19
 */
public interface BusinessModelIndexSettingService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessModelIndexSettingVO}>
     */
    PagingVO<BusinessModelIndexSettingVO> queryPaging(BusinessModelIndexSettingQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessModelIndexSettingVO}>
     */
    List<BusinessModelIndexSettingVO> queryListDynamic(BusinessModelIndexSettingQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessModelIndexSettingVO}
     */
    BusinessModelIndexSettingVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessModelIndexSettingVO}
     */
    BusinessModelIndexSettingVO insert(BusinessModelIndexSettingPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessModelIndexSettingVO}
     */
    BusinessModelIndexSettingVO update(BusinessModelIndexSettingPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessModelIndexSettingPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);
    /**
     * 通过主表id删除明细数据
     *
     * @param modelIndexId business_model_index.id 模型指标id
     *
     */
    void deleteSoftByModelIndexId(Long modelIndexId);

    /**
     * 通过modelid删除明细数据
     *
     * @param modelId business_strategy_model.id 模型id
     *
     */
    void deleteSoftByModelId(Long modelId);
}
