package com.elitesland.tw.tw5.api.prd.acc.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimJdePayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSourcePayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimExportVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimPrintVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;

import javax.servlet.http.HttpServletResponse;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

/**
 * 费用报销管理
 *
 * @author sunxw
 * @date 2023-11-22
 */
public interface AccReimService {

    /**
     * 分页
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccReimVO}>
     */
    PagingVO<AccReimVO> queryPaging(AccReimQuery query);

    /**
     * 列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccReimVO}>
     */
    List<AccReimVO> queryListDynamic(AccReimQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AccReimVO}
     */
    AccReimVO queryByKey(Long key);

    /**
     * 主键查询(simple)
     *
     * @param key
     * @return
     */
    AccReimVO queryOneByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AccReimVO}
     */
    AccReimVO insert(AccReimPayload payload);

    /**
     * 部分修改
     *
     * @param payload 单据数据
     * @return {@link Long}
     */
    long partialUpdate(AccReimPayload payload);

    /**
     * 更新支付状态信息
     *
     * @param payload
     */
    void updatePayStatus(AccReimPayload payload);

    /**
     * 动态修改
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AccReimPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据报销单号查询唯一
     *
     * @param reimNo
     * @return
     */
    AccReimVO queryOneByReimNo(String reimNo);

    /**
     * 修改付款方式
     *
     * @param keys
     * @param payMode
     */
    void updatePayMode(Long[] keys, String payMode);

    /**
     * 财务收单
     *
     * @param reimNo
     */
    AccReimVO finChargeUp(String reimNo);

    /**
     * 批量待记账/付款处理
     *
     * @param keys
     * @param type
     * @param expenseProofDigest 摘要
     */
    AccReimJdePayload batchChargeOrPay(List<Long> keys, String type, String expenseProofDigest, LocalDate expenseAccountDate, String payMode);

    /**
     * 费用计算 -> 计算当前用户当前核算项目的所需费用
     *
     * @param busItemCode
     * @param calcSource  费用计算数据来源
     * @return
     */
    AccReimSourcePayload calcAmt(String busItemCode, AccReimSourcePayload calcSource);

    /**
     * 记账导出
     *
     * @param response
     * @param batchId
     */
    void exportChargeDtl(HttpServletResponse response, Long batchId);

    /**
     * 付款导出
     *
     * @param response
     * @param batchId
     */
    void exportPayData(HttpServletResponse response, Long batchId);

    /**
     * 网银提交
     *
     * @param ids
     */
    void payBankSubmit(Long[] ids);

    /**
     * 修改收款账号
     *
     * @param payload
     */
    void updateBankAccount(AccReimPayload payload);

    /**
     * 我的报销待处理数据检查
     *
     * @param reimUserId
     * @return
     */
    boolean myReimCheck(Long reimUserId);

    /**
     * 预算-费用占用分页
     *
     * @param query
     * @return
     */
    PagingVO<AccReimVO> paging2Budget(AccReimQuery query);

    /**
     * 记账导出数据
     *
     * @param batchNo
     * @return
     */
    List<AccReimExportVO> getExportChargeData(String batchNo);

    /**
     * jde对接记账数据查询
     *
     * @param
     * @return
     */

    List<AccReimExportVO> getExportChargeDataByKeys(List<Long> keys);
    /**
     * 费用代记账更新
     *
     * @param keys 主键id集合
     * @param expenseProofDigest 费用凭证摘要
     * @param expenseProofNo 费用凭证号
     * @param expenseProofStatus 费用凭证状态
     * @param expenseProofFailReason 费用凭证失败原因
     * @return
     */
    void updateAccountDigestAndStatusByKeys(List<Long> keys, String expenseProofDigest,String expenseProofNo,String expenseProofStatus,String expenseProofFailReason);
    /**
     * 付款记账后更新
     *
     * @param keys 主键id集合
     * @param payProofDigest 付款凭证摘要
     * @param payProofNo 付款凭证号
     * @param payProofStatus 付款凭证状态
     * @param payProofFailReason 付款凭证失败原因
     * @return
     */
    void updatePayDigestAndStatusByKeys(List<Long> keys, String payProofDigest,String payProofNo,String payProofStatus,String payProofFailReason);

    /**
     * 付款待记账审批
     *
     * @param keys 主键id集合
     * @param payProofDigest 付款凭证摘要
     * @return
     */
    void batchPayCharge(List<Long> keys,String payProofDigest);

    // 记账导出数据处理
    void chargeExportDataHandle(List<AccReimExportVO> mainData, Map<Long, List<BusinessPartnerVO>> bookIdMap,
                                       Map<Long, List<PrdOrgOrganizationVO>> orgIdMap, Map<Long, List<PrdOrgEmployeeVO>> userIdMap,
                                       Map<Long, List<PmsProjectVO>> reasonIdMap, String batchNo);

    /**
     * 付款导出打印数据查询
     *
     * @param batchIdList
     */
    AccReimPrintVO queryPrintPayData(List<Long> batchIdList);

}
