package com.elitesland.tw.tw5.api.prd.budget.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetSubjectDetailPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetSubjectDetailQuery;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetSubjectDetailVO;

import java.util.List;

/**
 * 预算科目明细
 *
 * @author xxb
 * @date 2023-11-01
 */
public interface BudgetSubjectDetailService {

    /**
     * 批量插入
     *
     * @param subjectDetailPayloads
     */
    void batchSave(List<BudgetSubjectDetailPayload> subjectDetailPayloads);

    /**
     * 根据预算id查询
     *
     * @param budgetId
     * @return
     */
    List<BudgetSubjectDetailVO> queryListDyBudgetId(Long budgetId);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BudgetSubjectDetailVO}>
     */
    PagingVO<BudgetSubjectDetailVO> queryPaging(BudgetSubjectDetailQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BudgetSubjectDetailVO}>
     */
    List<BudgetSubjectDetailVO> queryListDynamic(BudgetSubjectDetailQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BudgetSubjectDetailVO}
     */
    BudgetSubjectDetailVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BudgetSubjectDetailVO}
     */
    BudgetSubjectDetailVO insert(BudgetSubjectDetailPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BudgetSubjectDetailVO}
     */
    BudgetSubjectDetailVO update(BudgetSubjectDetailPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BudgetSubjectDetailPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 通过预算主键删除科目明细
     *
     * @param budgetId 主键
     */
    long deleteSoftByBudgetId(Long budgetId);
}
