package com.elitesland.tw.tw5.api.prd.cal.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;


/**
 * 泛用当量结算单管理
 *
 * @author carl
 * @date 2023-11-15
 */
@Getter
@Setter
public class CalWideSettleVO extends BaseViewModel implements Serializable {
    /**
     * 结算单号
     */
    @ApiModelProperty("结算单号")
    private String settleNo;
    /**
     * 结算状态
     */
    @ApiModelProperty("结算状态")
    private String settleStatus;
    @UdcName(udcName = "CAL:SETTLE:STATUS", codePropName = "settleStatus")
    private String settleStatusDesc;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 申请资源id
     */
    @Comment("申请资源id")
    @Column()
    private Long applyResId;
    @UdcName(udcName = "USER", codePropName = "applyResId")
    private String applyResName;
    /**
     * 流程实例id
     */
    @ApiModelProperty("流程实例id")
    private String procInstId;
    /**
     * 结算类型（项目立项，项目结项。。。）
     */
    @ApiModelProperty("结算类型（项目立项，项目结项。。。）")
    private String settleType;
    @UdcName(udcName = "CAL:SETTLE:WIDE:TYPE", codePropName = "settleType")
    private String settleTypeDesc;
    /**
     * 结算日期
     */
    @ApiModelProperty("结算日期")
    private LocalDate settleDate;
    /**
     * 财务期间id
     */
    @ApiModelProperty("财务期间id")
    private Long finPeriodId;
    /**
     * 支出核算主题类型
     */
    @ApiModelProperty("支出核算主题类型")
    private String fromSourceType;
    /**
     * 支出核算主题id
     */
    @ApiModelProperty("支出核算主题id")
    private Long fromSourceId;
    /**
     * 支出核算主题名称（冗余）
     */
    @ApiModelProperty("支出核算主题名称（冗余）")
    private String fromSourceName;
    /**
     * 收入核算主题类型
     */
    @ApiModelProperty("收入核算主题类型")
    private String toSourceType;
    /**
     * 收入核算主题id
     */
    @ApiModelProperty("收入核算主题id")
    private Long toSourceId;
    /**
     * 收入核算主题名称（冗余）
     */
    @ApiModelProperty("收入核算主题名称（冗余）")
    private String toSourceName;
    /**
     * 申请结算当量数
     */
    @ApiModelProperty("申请结算当量数")
    private BigDecimal applySettleEqva;
    /**
     * 申请结算总额
     */
    @ApiModelProperty("申请结算总额")
    private BigDecimal applySettleAmt;
    /**
     * 结算单价
     */
    @ApiModelProperty("结算单价")
    private BigDecimal settlePrice;
    /**
     * 交易凭证文件code
     */
    @ApiModelProperty("交易凭证文件code")
    private String fileCodes;
    /**
     * 交易凭证文件
     */
    @ApiModelProperty("交易凭证文件")
    private Object fileDatas;
}
