package com.elitesland.tw.tw5.api.prd.copartner.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.copartner.payload.PerformanceReadmeConfigDetailPayload;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeConfigDetailQuery;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeConfigDetailVO;

import java.util.List;

/**
 * 合伙人绩效考核点维护
 *
 * @author carl
 * @date 2024-06-24
 */
public interface PerformanceReadmeConfigDetailService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PerformanceReadmeConfigDetailVO}>
     */
    PagingVO<PerformanceReadmeConfigDetailVO> queryPaging(PerformanceReadmeConfigDetailQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PerformanceReadmeConfigDetailVO}>
     */
    List<PerformanceReadmeConfigDetailVO> queryListDynamic(PerformanceReadmeConfigDetailQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PerformanceReadmeConfigDetailVO}
     */
    PerformanceReadmeConfigDetailVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PerformanceReadmeConfigDetailVO}
     */
    PerformanceReadmeConfigDetailVO insert(PerformanceReadmeConfigDetailPayload payload);


    /**
     * 批量新增
     *
     * @param payloads 单据数据
     * @return {@link PerformanceReadmeConfigDetailVO}
     */
    List<PerformanceReadmeConfigDetailVO> batchInsert(List<PerformanceReadmeConfigDetailPayload> payloads);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PerformanceReadmeConfigDetailPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据配置id逻辑删除
     *
     * @param configId 配置主键
     */
    void deleteSoftByConfigId(Long configId);
}
