package com.elitesland.tw.tw5.api.prd.inv.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 发票扩展表
 *
 * @author zoey
 * @date 2023-12-06
 */
@Getter
@Setter
public class InvInvoiceAttachedQuery extends TwQueryParam implements Serializable{
    /** 发票ID 精确 */
    @ApiModelProperty("发票ID")
    private Long invId;
    /** 百望系统发票ID 精确 */
    @ApiModelProperty("百望系统发票ID")
    private Long baiwangInvId;
    /** 百望系统发票扩展信息ID 精确 */
    @ApiModelProperty("百望系统发票扩展信息ID")
    private Long baiwangId;
    /** 承运人名称:承运人名称 精确 */
    @ApiModelProperty("承运人名称:承运人名称")
    private String carrierName;
    /** 承运人识别号:承运人识别号 精确 */
    @ApiModelProperty("承运人识别号:承运人识别号")
    private String carrierTaxNo;
    /** 受票方名称:受票方名称 精确 */
    @ApiModelProperty("受票方名称:受票方名称")
    private String draweeName;
    /** 受票方识别号:受票方识别号 精确 */
    @ApiModelProperty("受票方识别号:受票方识别号")
    private String draweeTaxNo;
    /** 运输货物信息:运输货物信息 精确 */
    @ApiModelProperty("运输货物信息:运输货物信息")
    private String cargoInformation;
    /** 起运地、经由、到达地:起运地、经由、到达地 精确 */
    @ApiModelProperty("起运地、经由、到达地:起运地、经由、到达地")
    private String transportRoute;
    /** 车船吨位:车船吨位 精确 */
    @ApiModelProperty("车船吨位:车船吨位")
    private BigDecimal tonnage;
    /** 主管税务机关:主管税务机关 精确 */
    @ApiModelProperty("主管税务机关:主管税务机关")
    private String taxAuthorityNo;
    /** 主管税务名称:主管税务名称 精确 */
    @ApiModelProperty("主管税务名称:主管税务名称")
    private String taxAuthorityName;
    /** 身份证号码 组织机构代码:身份证号码/组织机构代码 精确 */
    @ApiModelProperty("身份证号码 组织机构代码:身份证号码/组织机构代码")
    private String idCardNo;
    /** 车辆类型:车辆类型 精确 */
    @ApiModelProperty("车辆类型:车辆类型")
    private String vehicleType;
    /** 车辆识别代号/车架号码:车辆识别代号/车架号码 精确 */
    @ApiModelProperty("车辆识别代号/车架号码:车辆识别代号/车架号码")
    private String vehicleNo;
    /** 厂牌型号:厂牌型号 精确 */
    @ApiModelProperty("厂牌型号:厂牌型号")
    private String brandModel;
    /** 产地:产地 精确 */
    @ApiModelProperty("产地:产地")
    private String originPlace;
    /** 合格证号:合格证号 精确 */
    @ApiModelProperty("合格证号:合格证号")
    private String certiticateNo;
    /** 商检单号:商检单号 精确 */
    @ApiModelProperty("商检单号:商检单号")
    private String inspectionListNo;
    /** 发动机号:发动机号 精确 */
    @ApiModelProperty("发动机号:发动机号")
    private String engineNo;
    /** 进口证明书号:进口证明书号 精确 */
    @ApiModelProperty("进口证明书号:进口证明书号")
    private String importCertificateNo;
    /** 销货单位名称:销货单位名称（销方名称） 精确 */
    @ApiModelProperty("销货单位名称:销货单位名称（销方名称）")
    private String sellerName;
    /** 销方电话:销方电话 精确 */
    @ApiModelProperty("销方电话:销方电话")
    private String phoneNo;
    /** 账号:账号 精确 */
    @ApiModelProperty("账号:账号")
    private String account;
    /** 销方地址:销方地址 精确 */
    @ApiModelProperty("销方地址:销方地址")
    private String address;
    /** 银行:银行 精确 */
    @ApiModelProperty("银行:银行")
    private String bank;
    /** 税率:税率 精确 */
    @ApiModelProperty("税率:税率")
    private BigDecimal goodsTaxRate;
    /** 限乘人数:限乘人数 精确 */
    @ApiModelProperty("限乘人数:限乘人数")
    private Integer passengersLimited;
    /** 通行费标志:通行费标志 06-可抵扣通行费，07-不可抵扣通行费 精确 */
    @ApiModelProperty("通行费标志:通行费标志 06-可抵扣通行费，07-不可抵扣通行费")
    private String tollSign;
    /** 经营，拍卖单位地址:经营，拍卖单位地址 精确 */
    @ApiModelProperty("经营，拍卖单位地址:经营，拍卖单位地址")
    private String auctionAddress;
    /** 经营，拍卖单位:经营，拍卖单位 精确 */
    @ApiModelProperty("经营，拍卖单位:经营，拍卖单位")
    private String auctionName;
    /** 经营，拍卖单位电话:经营，拍卖单位电话 精确 */
    @ApiModelProperty("经营，拍卖单位电话:经营，拍卖单位电话")
    private String auctionPhone;
    /** 经营，拍卖单位纳税人识别号:经营，拍卖单位纳税人识别号 精确 */
    @ApiModelProperty("经营，拍卖单位纳税人识别号:经营，拍卖单位纳税人识别号")
    private String auctionTaxNo;
    /** 开户银行及账号:开户银行及账号 精确 */
    @ApiModelProperty("开户银行及账号:开户银行及账号")
    private String auctionBank;
    /** 买方电话:买方电话 精确 */
    @ApiModelProperty("买方电话:买方电话")
    private String purchaserPhone;
    /** 登记证号:登记证号 精确 */
    @ApiModelProperty("登记证号:登记证号")
    private String registrationNumber;
    /** 二手车市场地址:二手车市场地址 精确 */
    @ApiModelProperty("二手车市场地址:二手车市场地址")
    private String usedCarAddress;
    /** 二手车市场:二手车市场 精确 */
    @ApiModelProperty("二手车市场:二手车市场")
    private String usedCarName;
    /** 二手车市场电话:二手车市场电话 精确 */
    @ApiModelProperty("二手车市场电话:二手车市场电话")
    private String usedCarPhone;
    /** 二手车市场纳税人识别号:二手车市场纳税人识别号 精确 */
    @ApiModelProperty("二手车市场纳税人识别号:二手车市场纳税人识别号")
    private String usedCarTaxNo;
    /** 二手车市场开户银行及账号:二手车市场开户银行及账号 精确 */
    @ApiModelProperty("二手车市场开户银行及账号:二手车市场开户银行及账号")
    private String usedCarBank;
    /** 车牌照号:车牌照号 精确 */
    @ApiModelProperty("车牌照号:车牌照号")
    private String carNumber;
    /** 转入地车辆车管所名称:转入地车辆车管所名称 精确 */
    @ApiModelProperty("转入地车辆车管所名称:转入地车辆车管所名称")
    private String vehiclePlaceName;
    /** 是否删除:是否删除，0-否，1-是 精确 */
    @ApiModelProperty("是否删除:是否删除，0-否，1-是")
    private Integer isDel;
}
