package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

/**
 * 员工月度工时统计查询
 *
 * @author likunpeng
 * @date 2024/5/10
 */
@Data
public class MonthlyTimesheetQuery extends AbstractOrderQueryParam {
    /**
     * 日期开始
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate workDateStart;

    /**
     * 日期结束
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate workDateEnd;
    /**
     * 工时审批状态
     */
    private List<String> status = new ArrayList<>();

    /**
     * 资源类型 内部 INTERNAL_RES,/外部 EXTERNAL_RES
     */
    private String resType;

    /**
     * 参考合同号
     */
    private String refContractNo;

    /**
     * 资源姓名【工时填报人ID】
     */
    private Long tsUserId;
}
