package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetPlanQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.ProjectAndTaskVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetPlanVO;

import java.util.List;

/**
 * 工时-工作计划
 *
 * @author duwh
 * @date 2022-12-09
 */
public interface TimesheetPlanService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TimesheetPlanVO}>
     */
    PagingVO<TimesheetPlanVO> paging(TimesheetPlanQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TimesheetPlanVO}>
     */
    List<TimesheetPlanVO> queryList(TimesheetPlanQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TimesheetPlanVO}
     */
    TimesheetPlanVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TimesheetPlanVO}
     */
    TimesheetPlanVO insert(TimesheetPlanPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TimesheetPlanVO}
     */
    TimesheetPlanVO update(TimesheetPlanPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 逻辑删除
     *
     * @param yeerWeek    年周
     * @param loginUserId 登录用户id
     */
    void deleteSoftByYearWeek(Integer yeerWeek, Long loginUserId);

    /**
     * 项目和任务列表
     *
     * @param keyword 关键字
     * @param type
     * @param test
     * @return {@link List}<{@link ProjectAndTaskVO}>
     */
    List<ProjectAndTaskVO> listProjAndTask(String keyword, String type, boolean test);

    /**
     * 批量插入
     *
     * @param payload 有效载荷
     * @return {@link List}<{@link TimesheetPlanVO}>
     */
    List<TimesheetPlanVO> batchInsert(TimesheetPlanListPayload payload);

    /**
     * 复制上周计划
     *
     * @param date 日期
     * @return {@link List}<{@link TimesheetPlanVO}>
     */
    List<TimesheetPlanVO> copyLastWeek(String date);

    /**
     * @description: 同步工作计划到tw4.0
     * @author: dragonHuang
     * @date: 2023/7/25 16:54
     * @param: param
     * @return: void
     **/

    @Deprecated
    void syncWorkPlanTo4(String param);
}
