package com.elitesland.tw.tw5.api.prd.my.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 远程办公申请
 *
 * @author carl
 * @date 2024-04-19
 */
@Getter
@Setter
public class AbnormalWorkApplyVO extends BaseViewModel implements Serializable {
    /**
     * 外出申请人id
     */
    @ApiModelProperty("外出申请人id")
    private Long applyUserId;
    @UdcName(udcName = "USER", codePropName = "applyUserId")
    private String applyUserName;
    /**
     * 归属bu_id
     */
    @ApiModelProperty("归属bu_id")
    private Long orgId;
    @UdcName(udcName = "BU", codePropName = "orgId")
    private String orgName;
    /**
     * base地id
     */
    @ApiModelProperty("base地id")
    private String baseAddrId;
    @UdcName(udcName = "org:employee:serviceaddr", codePropName = "baseAddrId")
    private String baseAddrName;
    /**
     * 直属领导id
     */
    @ApiModelProperty("直属领导id")
    private Long parentUserId;
    @UdcName(udcName = "USER", codePropName = "applyUserId")
    private String parentUserName;
    /**
     * 岗位
     */
    @ApiModelProperty("岗位")
    private String jobs;
    /**
     * 级别
     */
    @ApiModelProperty("级别")
    private String grade;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /**
     * 远程办公日期开始
     */
    @ApiModelProperty("远程办公日期开始")
    private LocalDate abnormalWorkDateStart;

    /**
     * 远程办公日期结束
     */
    @ApiModelProperty("远程办公日期结束")
    private LocalDate abnormalWorkDateEnd;
    /**
     * 远程办公天数
     */
    @ApiModelProperty("远程办公天数")
    private BigDecimal days;

    /**
     * 事由类型
     */
    @ApiModelProperty("事由类型")
    private String reasonType;

    /**
     * 事由ID
     */
    @ApiModelProperty("事由ID")
    private Long reasonId;
    /**
     * 事由名称
     */
    @ApiModelProperty("事由名称")
    private String reasonName;
    /**
     * 远程工作地
     */
    @ApiModelProperty("远程工作地")
    private String abnormalWorkAddr;
    /**
     * 编号
     */
    @ApiModelProperty("编号")
    private String applyNo;
    /**
     * 名称
     */
    @ApiModelProperty("名称")
    private String applyName;
    /**
     * 任务状态
     */
    @ApiModelProperty("任务状态")
    private String applyStatus;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String procInstStatus;
    @UdcName(udcName = "appr_status", codePropName = "procInstStatus")
    private String procInstStatusDesc;
    /**
     * 流程id
     */
    @ApiModelProperty("流程id")
    private String procInstId;

    @ApiModelProperty("明细数据")
    private List<AbnormalWorkApplyDetailVO> abnormalWorkApplyDetailVOList;
}
