package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectReportPlanPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectReportPlanQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectReportPlanVO;

import java.util.List;

/**
 * 项目汇报计划管理
 *
 * @author carl
 * @date 2023-09-05
 */
public interface PmsProjectReportPlanService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsProjectReportPlanVO}>
     */
    PagingVO<PmsProjectReportPlanVO> queryPaging(PmsProjectReportPlanQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectReportPlanVO}>
     */
    List<PmsProjectReportPlanVO> queryListDynamic(PmsProjectReportPlanQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsProjectReportPlanVO}
     */
    PmsProjectReportPlanVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsProjectReportPlanVO}
     */
    PmsProjectReportPlanVO insert(PmsProjectReportPlanPayload payload);

    /**
     * 批量新增
     *
     * @param payloads 单据数据
     * @return {@link PmsProjectReportPlanVO}
     */
    void batchInsert(List<PmsProjectReportPlanPayload> payloads);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsProjectReportPlanVO}
     */
    PmsProjectReportPlanVO update(PmsProjectReportPlanPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PmsProjectReportPlanPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
