package com.elitesland.tw.tw5.api.prd.purchase.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.time.LocalDate;
import java.math.BigDecimal;


/**
  * 旧采购合同付款计划
  *
  * @author likunpeng
  * @date 2024-01-09
  */
@Getter
@Setter
public class PcontractPayplanVO extends BaseViewModel implements Serializable {
    /** 采购合同ID */
    @ApiModelProperty("采购合同ID")
    private Long pcontractId;
    /** 行号 */
    @ApiModelProperty("行号")
    private BigDecimal lineNo;
    /** 付款阶段 */
    @ApiModelProperty("付款阶段")
    private String phaseDesc;
    /** 付款号 */
    @ApiModelProperty("付款号")
    private String payNo;
    /** 付款状态 */
    @ApiModelProperty("付款状态")
    private String payStatus;
    @UdcName(udcName = "purchase:old_con:PAY_STATUS", codePropName = "payStatus")
    private String payStatusDesc;
    /** 审批状态 */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /** 当期付款比例 */
    @ApiModelProperty("当期付款比例")
    private BigDecimal payRatio;
    /** 当期付款金额 */
    @ApiModelProperty("当期付款金额")
    private BigDecimal payAmt;
    /** 预计付款日期 */
    @ApiModelProperty("预计付款日期")
    private LocalDate planPayDate;
    /** 已付款金额 */
    @ApiModelProperty("已付款金额")
    private BigDecimal actualPayAmt;
    /** 实际付款日期 */
    @ApiModelProperty("实际付款日期")
    private LocalDate actualPayDate;
    /** 计划状态 */
    @ApiModelProperty("计划状态")
    private String planStatus;
    /** 付款阶段号 */
    @ApiModelProperty("付款阶段号")
    private String phaseNo;
}
