package com.elitesland.tw.tw5.api.prd.purchase.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 采购合同终止
 *
 * @author lemon
 * @date 2023-10-19
 */
@Getter
@Setter
public class TPurchaseContractOverVO extends BaseViewModel implements Serializable {
    /**
     * 合同终止编号
     */
    @ApiModelProperty("合同终止编号")
    private String overNo;
    /**
     * 申请人资源ID
     */
    @ApiModelProperty("申请人资源ID")
    private Long applyResId;
    /**
     * 合同终止状态
     */
    @ApiModelProperty("合同终止状态")
    private String overStatus;
    /**
     * 采购合同ID
     */
    @ApiModelProperty("采购合同ID")
    private Long contractId;
    /**
     * 采购合同编号
     */
    @ApiModelProperty("采购合同编号")
    private String contractNo;
    /**
     * 终止原因
     */
    @ApiModelProperty("终止原因")
    private String overWhy;
    /**
     * 终止日期
     */
    @ApiModelProperty("终止日期")
    private LocalDate overTime;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
}
