package com.elitesland.tw.tw5.api.prd.sale.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 合同
 *
 * @author duwh
 * @date 2022/09/27
 */
@Data
public class SaleContractPayload extends TwCommonPayload {

    /**
     * 模板主键
     */
    private Long tempId;

    /**
     * 标签id
     */
    private Long tagId;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 合同编号
     */
    private String contractNo;

    /**
     * 合同金额
     */
    private BigDecimal amt;

    /**
     * 合同状态
     */
    private String contractStatus;

    /**
     * 合同描述
     */
    private String contractDesc;

    /**
     * 流程实例ID
     */
    private String procInstId;

    /**
     * 流程审批状态
     */
    private ProcInstStatus procInstStatus;

    /**
     * 提交时间
     */
    private LocalDateTime submitTime;

    /**
     * 审批时间
     */
    private LocalDateTime approvedTime;


}
