package com.elitesland.tw.tw5.api.prd.acc.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingLimitPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingLimitQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingLimitVO;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;

/**
 * 报销额度配置
 *
 * @author zoey
 * @date 2024-05-14
 */
public interface AccReimSettingLimitService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccReimSettingLimitVO}>
     */
    PagingVO<AccReimSettingLimitVO> queryPaging(AccReimSettingLimitQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccReimSettingLimitVO}>
     */
    List<AccReimSettingLimitVO> queryListDynamic(AccReimSettingLimitQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AccReimSettingLimitVO}
     */
    AccReimSettingLimitVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AccReimSettingLimitVO}
     */
    AccReimSettingLimitVO insert(AccReimSettingLimitPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AccReimSettingLimitVO}
     */
    AccReimSettingLimitVO update(AccReimSettingLimitPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AccReimSettingLimitPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 规则校验
     * @param key
     * @param reimUserId
     * @return
     */
    AccReimSettingLimitVO ruleCheck(Long key, Long reimUserId, BigDecimal reimAmt, String expensePlaceGrade);
}
