package com.elitesland.tw.tw5.api.prd.acc.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingTitlePayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingTitleQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingOverdueVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingTitleVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingVO;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVO;

import java.util.List;

/**
 * 报销抬头校验
 *
 * @author zoey
 * @date 2024-05-14
 */
public interface AccReimSettingTitleService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccReimSettingTitleVO}>
     */
    PagingVO<AccReimSettingTitleVO> queryPaging(AccReimSettingTitleQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccReimSettingTitleVO}>
     */
    List<AccReimSettingTitleVO> queryListDynamic(AccReimSettingTitleQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AccReimSettingTitleVO}
     */
    AccReimSettingTitleVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AccReimSettingTitleVO}
     */
    AccReimSettingTitleVO insert(AccReimSettingTitlePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AccReimSettingTitleVO}
     */
    AccReimSettingTitleVO update(AccReimSettingTitlePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AccReimSettingTitlePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 规则校验
     * @param key
     * @param invInvoiceVOS
     * @param reimUserId
     * @return
     */
    AccReimSettingTitleVO ruleCheck(Long key, List<InvInvoiceVO> invInvoiceVOS, Long reimUserId, Long expenseCompanyId);
}
