package com.elitesland.tw.tw5.api.prd.budget.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetChangePayload;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetQuery;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetChangeVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;

import java.util.List;

/**
 * 预算基本信息
 *
 * @author xxb
 * @date 2023-11-01
 */
public interface BudgetService {


    /**
     * 通过 资源 查询预算
     *
     * @param sourceId
     * @param sourceType
     * @return
     */
    BudgetVO queryBySource(Long sourceId, String sourceType);


    /////////////////////////////////////////////////////////////

    /**
     * 首次预算-新增或修改
     *
     * @param payload 有效载荷
     */
    Long saveFirstBudget(BudgetPayload payload);

    /**
     * 预算变更-新增或修改
     *
     * @param budgetChangePayload 有效载荷
     */
    void saveBudgetChange(BudgetChangePayload budgetChangePayload);

    /**
     * BU预算、商机预算 -新增或修改
     * BU预算 、商机预算 不需要预算控制
     * BU预算 、商机预算 不需要走靠流程
     * BU预算 、商机预算 不需要拨付
     * BU 规划当量、规划费用 可编辑
     * 商机 规划当量、规划费用 默认为0，不可更改
     *
     * @param payload
     */
    void saveOPPOAndBUTypeBudget(BudgetPayload payload);


    /**
     * 预算信息-预算主键查询
     *
     * @param key 关键
     */
    BudgetVO queryBudgetByKey(Long key);

    /**
     * 仅查询预算
     *
     * @param key
     * @return
     */
    BudgetVO queryByKey(Long key);


    /**
     * 预算变更信息-变更主键查询
     *
     * @param key 关键
     */
    BudgetChangeVO queryBudgetChangeByKey(Long key);


    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BudgetVO}>
     */
    PagingVO<BudgetVO> queryPaging(BudgetQuery query);

    /**
     * 预算列表
     *
     * @param query
     * @return
     */
    List<BudgetVO> queryList(BudgetQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 流程回调
     *
     * @param payload
     */
    void processStatusChange(ProcessStatusChangePayload payload);

    /**
     * 没有建立过预算的项目
     *
     * @return
     */
    List<PmsProjectVO> queryProjectNoBudget();

    /**
     * 同步科目模板
     *
     * @param keys 主键
     * @return result
     */
    void synchronizationTemp(List<Long> keys, Long tmplId);

    /**
     * 预算变更临时表
     */
    void syncBudgetChangeTmp();

    /**
     * * 获取预算风险等级（执行区）
     */
    String queryBudgetRiskLevel(Long sourceId, String sourceType, Long contractId);

    /**
     * 单字段编辑
     *
     * @param payload
     */
    void updateByKeyDynamic(BudgetPayload payload);
}
