package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 商机review
 *
 * @author zoey
 * @date 2023-11-01
 */
@Getter
@Setter
public class CrmOpportunityReviewPayload extends TwCommonPayload  implements Serializable {
    /** 商机id */
    @ApiModelProperty("商机id")
    private Long oppoId;
    /** 风险类型 */
    @ApiModelProperty("风险类型")
    private String riskType;
    /** 风险点描述 */
    @ApiModelProperty("风险点描述")
    private String riskDesc;
    /** 应对计划 */
    @ApiModelProperty("应对计划")
    private String answerPlan;
    /** 计划结束时间 */
    @ApiModelProperty("计划结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate planEndTime;
    /** 负责人 */
    @ApiModelProperty("负责人")
    private Long directorUserId;
    /** 已完成、未完成、进行中 */
    @ApiModelProperty("已完成、未完成、进行中")
    private String finishState;
}
