package com.elitesland.tw.tw5.api.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmGiftListPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmGiftListQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmGiftListVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;

import java.util.List;

/**
 * 礼品单
 *
 * @author xxb
 * @date 2023-08-31
 */
public interface CrmGiftListService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link CrmGiftListVO}>
     */
    PagingVO<CrmGiftListVO> queryPaging(CrmGiftListQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link CrmGiftListVO}>
     */
    List<CrmGiftListVO> queryListDynamic(CrmGiftListQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link CrmGiftListVO}
     */
    CrmGiftListVO queryByKey(Long key);

    /**
     *  获取可以礼品申请的用户
     */
    List<PrdOrgEmployeeVO> queryUserByGiftRole();

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link CrmGiftListVO}
     */
    CrmGiftListVO insert(CrmGiftListPayload payload);

    /**
     * 新增
     */
    CrmGiftListVO create();


    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(CrmGiftListPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);


}
