package com.elitesland.tw.tw5.api.prd.humanresources.payload;

import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;


/**
 * @author : WWW
 * @date : 2023-11-1
 * @desc : base地与社保地变更申请
 */

@Data
@ApiModel(description = "base地与社保地变更申请")
public class PrdBaseRegionChangePayload extends TwCommonPayload {


    /**
     * 申请人id
     */
    @ApiModelProperty("申请人id")
    private Long applyUserId;

    /**
     * 申请人
     */
    @ApiModelProperty("申请人")
    private String applyUser;

    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;

    /**
     * 入职日期
     */
    @ApiModelProperty("入职日期")
    private LocalDate entryDate;

    /**
     * 合作方式
     */
    @ApiModelProperty("合作方式")
    private String cooperateType;

    /**
     * 公司id
     */
    @ApiModelProperty("公司id")
    private String ouId;

    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String ouName;

    /**
     * basebu
     */
    @ApiModelProperty("basebu")
    private Long baseBuId;

    /**
     * 原base地
     */
    @ApiModelProperty("原base地")
    private String oldBaseRegion;

    /**
     * 新base地
     */
    @ApiModelProperty("新base地")
    private String newBaseRegion;

    /**
     * 原社保缴纳地
     */
    @ApiModelProperty("原社保缴纳地")
    private String oldSocialRegion;

    /**
     * 新社保缴纳地
     */
    @ApiModelProperty("新社保缴纳地")
    private String newSocialRegion;

    /**
     * 变更原因
     */
    @ApiModelProperty("变更原因")
    private String changeReason;

    /**
     * 生效日期
     */
    @ApiModelProperty("生效日期")
    private LocalDate activeDate;

    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String applyState;

    /**
     * 新增成本
     */
    @ApiModelProperty("新增成本")
    private BigDecimal newCost;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
}

