package com.elitesland.tw.tw5.api.prd.humanresources.payload;

import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;
import java.util.List;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;


/**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 绩效考核
 */

@Data
@ApiModel(description = "绩效考核")
public class PrdPerformanceExamPayload extends TwCommonPayload {


    /**
     * 考核名称
     */
    @ApiModelProperty("考核名称")
    private String name;

    /**
     * 考核周期
     */
    @ApiModelProperty("考核周期")
    private String cycle;

    /**
     * 开始期间
     */
    @ApiModelProperty("开始期间")
    private LocalDate startPeriod;

    /**
     * 结束期间
     */
    @ApiModelProperty("结束期间")
    private LocalDate endPeriod;

    /**
     * 状态 0创建  1进行中  2已完成
     */
    @ApiModelProperty("状态 0创建  1进行中  2已完成")
    private String state;

    /**
     * 考核说明
     */
    @ApiModelProperty("考核说明")
    private String examDesc;

    /**
     * 分数下限
     */
    @ApiModelProperty("分数下限")
    private BigDecimal scoreMin;

    /**
     * 分数上限
     */
    @ApiModelProperty("分数上限")
    private BigDecimal scoreMax;

    /**
     * 考试结果审批人类型
     */
    @ApiModelProperty("考试结果审批人类型")
    private String resAuditorType;

    /**
     * 考试结果审批人
     */
    @ApiModelProperty("考试结果审批人")
    private String resAuditor;

    /**
     * 模板id
     */
    @ApiModelProperty("模板id")
    private Long tempId;

    /**
     * 绩效考核点
     */
    @ApiModelProperty("绩效考核点")
    private List<PrdPerformanceExamPointPayload> prdPerformanceExamPointPayloadList;

    /**
     * 考核结果等级
     */
    @ApiModelProperty("考核结果等级")
    private List<PrdPerformanceExamGradePayload> prdPerformanceExamGradePayloadList;

    /**
     * 可查看考核相关人员
     */
    @ApiModelProperty("可查看考核相关人员")
    private List<PrdPerformanceExamRelatePayload> prdPerformanceExamRelatePayloadList;


    /**
     * 考核范围
     */
    @ApiModelProperty("考核范围")
    private List<PrdPerformanceExamRangePayload> prdPerformanceExamRangePayloadList;

}

