package com.elitesland.tw.tw5.api.prd.humanresources.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PersonResPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdOrgResQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonResChangeVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonResVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeBSVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;

import java.time.LocalDate;
import java.util.List;

public interface PersonResService {

    /**
     * 资源库分页查询
     *
     * @param query
     * @return
     */
    PagingVO<PrdOrgEmployeeVO> page(PrdOrgEmployeeQuery query);

    /**
     * 根据id查询资源库详情
     *
     * @param id
     * @return
     */
    PersonResVO queryById(Long id);

    /**
     * 根据id查询资源库详情
     *
     * @param userId
     * @return
     */
    PersonResVO queryByUserId(Long userId);

    /**
     * 资源库信息修改
     *
     * @param personResVO
     * @return
     */
    void update(PersonResVO personResVO);

    /**
     * 个人信息变更提交
     *
     * @param payload
     * @return
     */
    Long personInfoChangeSubmit(PersonResPayload payload);

    /**
     * 个人信息变更信息对比
     *
     * @param procId
     * @param employeeId
     * @return
     */
    PersonResChangeVO personalChangeInfo(Long employeeId, String procId);

    /**
     * 获取员工内推人
     *
     * @param userId
     * @return
     */
    Long getJobInternalRecommUserId(Long userId);

    /**
     * 权限查询-分页列表
     *
     * @param query
     * @return
     */
    PagingVO<PrdOrgEmployeeBSVO> permissionPaging(PrdOrgResQuery query);

    /**
     * 获取在职的用户Id List
     *
     * @param prdOrgEmployeeQuery
     * @return
     */
    List<Long> getJobingUserList(PrdOrgEmployeeQuery prdOrgEmployeeQuery);

    /**
     * 修改员工信息(外部资源引入)
     *
     * @param payload
     * @return
     */
    void updateEmployee(PrdOrgEmployeePayload payload);

    /**
     * 一键离职
     *
     * @param id
     * @return
     */
    void depart(Long id, LocalDate date);

    /**
     * 个人信息变更修改
     *
     * @param payload
     * @return
     */
    void updateChange(PersonResPayload payload);
}
