package com.elitesland.tw.tw5.api.prd.humanresources.vo;

import lombok.Data;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;
import java.util.List;

import io.swagger.annotations.ApiModel;
import com.elitescloud.boot.common.param.BaseViewModel;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价表
 */

@Data
@ApiModel(description = "评价表")
public class PrdEvaluateVO extends BaseViewModel {


    /**
     * 来源id
     */
    @ApiModelProperty("来源id")
    private Long fromId;

    /**
     * 配置id
     */
    @ApiModelProperty("配置id")
    private Long configId;

    /**
     * 评价对象名称
     */
    @ApiModelProperty("评价对象名称")
    private String itemName;

    /**
     * 评价类别
     */
    @ApiModelProperty("评价类别")
    private String cate;
    private String cateDesc;

    /**
     * 评价类型
     */
    @ApiModelProperty("评价类型")
    private String type;
    private String typeDesc;

    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long proId;

    /**
     * 任务id
     */
    @ApiModelProperty("任务id")
    private Long taskId;

    /**
     * 活动id
     */
    @ApiModelProperty("活动id")
    private Long actId;

    /**
     * 评价说明
     */
    @ApiModelProperty("评价说明")
    private String evalDesc;

    /**
     * 评价日期
     */
    @ApiModelProperty("评价日期")
    private LocalDate evalDate;

    /**
     * 评价人
     */
    @ApiModelProperty("评价人")
    private String evalUser;

    /**
     * 评价人id
     */
    @ApiModelProperty("评价人id")
    private Long evalUserId;

    /**
     * 被评价人
     */
    @ApiModelProperty("被评价人")
    private String toEvalUser;

    /**
     * 被评价人id
     */
    @ApiModelProperty("被评价人id")
    private Long toEvalUserId;

    /**
     * 平均分数
     */
    @ApiModelProperty("平均分数")
    private BigDecimal averageScore;

    /**
     * 评价明细集合
     */
    @ApiModelProperty("评价明细集合")
    private List<PrdEvaluateDtlVO> prdEvaluateDtlVOList;
}

