package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 资金划款
 *
 * @author wangluyu
 * @date 2024-02-27
 */
@Getter
@Setter
public class TMoneyTransferQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 编号 精确 */
    @ApiModelProperty("编号")
    private String transferNo;
    /** 申请人 精确 */
    @ApiModelProperty("申请人")
    private Long applicantUserId;
    /** 申请日期 精确 */
    @ApiModelProperty("申请日期")
    private LocalDate applicantTime;
    /** 申请人所属bu 精确 */
    @ApiModelProperty("申请人所属bu")
    private Long applicantBuId;
    /** 划款公司 精确 */
    @ApiModelProperty("划款公司")
    private String transferCompany;
    /** 划款公司bookid 精确 */
    @ApiModelProperty("划款公司bookid")
    private Long transferCompanyBookId;
    /** 划款账号 精确 */
    @ApiModelProperty("划款账号")
    private String transferAccount;
    /** 收款公司 精确 */
    @ApiModelProperty("收款公司")
    private String collectionCompany;
    /** 收款公司bookid 精确 */
    @ApiModelProperty("收款公司bookid")
    private Long collectionCompanyBookId;
    /** 收款账号 精确 */
    @ApiModelProperty("收款账号")
    private String collectionAccount;
    /** 划款金额 精确 */
    @ApiModelProperty("划款金额")
    private BigDecimal transferMoney;
    /** 支付方式 udc[ADMINISTRATION:COST:ACC_PAY_WAY] 精确 */
    @ApiModelProperty("支付方式 udc[ADMINISTRATION:COST:ACC_PAY_WAY]")
    private String payWay;
    /** 划款说明 精确 */
    @ApiModelProperty("划款说明")
    private String transferNote;
    /** 划款状态 udc[ADMINISTRATION:COST:ACC_TRANSFER_STATUS] 精确 */
    @ApiModelProperty("划款状态 udc[ADMINISTRATION:COST:ACC_TRANSFER_STATUS]")
    private String transferStatus;
    /** 流程实例ID 精确 */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 精确 */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /** 提交时间 精确 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /** 审批时间 精确 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;


    /**
     * 支付方式：1.网银支付 2.手动支付
     */
    @ApiModelProperty("支付方式：1.网银支付 2.手动支付")
    private Integer payMode;


    /**
     * 支付状态：S 成功、F 失败、C撤销、D 过期、R 否决 G退票
     */
    @ApiModelProperty("支付状态：S 成功、F 失败、C撤销、D 过期、R 否决 G退票")
    private String payStatus;


    /**
     * 内部往来凭证
     */
    @ApiModelProperty("内部往来凭证")
    private String jdeDocNo;


    /**
     * 内部往来凭证2
     */
    @ApiModelProperty("内部往来凭证2")
    private String jdeDocNo2;
}
