package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitesland.tw.tw5.api.prd.my.payload.TBusiSignetApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TBusiSignetApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TBusiSignetApplyVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 用印申请
 *
 * @author wangly
 * @date 2023-09-14
 */
public interface TBusiSignetApplyService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TBusiSignetApplyVO}>
     */
    PagingVO<TBusiSignetApplyVO> queryPaging(TBusiSignetApplyQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TBusiSignetApplyVO}>
     */
    List<TBusiSignetApplyVO> queryListDynamic(TBusiSignetApplyQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TBusiSignetApplyVO}
     */
    TBusiSignetApplyVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TBusiSignetApplyVO}
     */
    TBusiSignetApplyVO insert(TBusiSignetApplyPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TBusiSignetApplyVO}
     */
    TBusiSignetApplyVO update(TBusiSignetApplyPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TBusiSignetApplyPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
