package com.elitesland.tw.tw5.api.prd.org.service;

import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeEqvaRatioPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeGradePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeEqvaRatioQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeEqvaRatioVO;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2023/6/2 - 13:32
 */
public interface PrdOrgEmployeeEqvaRatioService {

    /**
     * 获取员工当量系数
     *
     * @param userId
     * @param date
     * @return
     */
    BigDecimal getEqvaRatio(Long userId, LocalDate date);

    /**
     * 获取员工当量系数  默认当量系数为0
     *
     * @param userId 用户id
     * @param date   日期
     * @return {@link BigDecimal}
     */
    BigDecimal getEqvaRatioDefaultZero(Long userId, LocalDate date);

    /**
     * 获取员工区间当量系数列表
     *
     * @param query
     * @return
     */
    List<PrdOrgEmployeeEqvaRatioVO> getEqvaRatioListByDate(PrdOrgEmployeeEqvaRatioQuery query);

    /**
     * 批量修改员工职级、当量系数
     *
     * @param
     * @return
     */
    void batchUpsert(PrdOrgEmployeeGradePayload payload);

    /**
     * 修改员工职级、当量系数
     *
     * @param
     * @return
     */
    void upsertEqvaRatio(PrdOrgEmployeeEqvaRatioPayload payload);
}
