package com.elitesland.tw.tw5.api.prd.partner.business.service;


import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.PartnerBusinessCountVO;

import java.util.List;

/**
 * 业务伙伴管理
 *
 * @author wangluyu
 * @date 2023-05-16
 */
public interface CrmBusinessPartnerService {

    /**
     * 补充启信宝信息
     *
     * @param partnerName 伙伴名称
     * @param partnerId   业务伙伴主键 business_partner.id
     * @param bookId      地址簿主键
     * @return boolean
     */
    boolean fillQxbInfo(String partnerName, long partnerId, Long bookId);

    /**
     * 删除启信宝信息
     *
     * @param partnerId   业务伙伴主键 business_partner.id
     * @return boolean
     */
    void deleteQxbInfo(long partnerId);

    /**
     * 补充启信宝信息
     *
     * @param keys 键
     * @return boolean
     */
    boolean fillQxbInfo(List<Long> keys);

    /**
     * 经营往来
     *
     * @param partnerId 合作伙伴id
     * @return {@link List}<{@link CrmFollowVO}>
     */
    List<CrmFollowVO> followList(Long partnerId,String type);

    /**
     * 经营往来统计个数
     *
     * @param partnerId 合作伙伴id
     * @return long
     */
    long countFollowList(Long partnerId);

    /**
     * 统计业务往来个数
     *
     * @param partnerId 合作伙伴id
     * @return long
     */
    long countBusiness(Long partnerId,Long bookId);

    //业务往来列表查询
    List<PartnerBusinessCountVO> businessCount(Long partnerId);
}
