package com.elitesland.tw.tw5.api.prd.purchase.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 付款申请单--应付会计审批payload
 *
 * @author likunpeng
 * @date 2023-12-07
 */
@Getter
@Setter
public class PaymentAccountantApprovePayload extends TwCommonPayload implements Serializable {
    /** 财务记账付款公司地址簿Id */
    @ApiModelProperty("财务记账付款公司地址簿Id")
    private Long finalPaymentCompanyBookId;
    /** 财务记账付款银行 */
    @ApiModelProperty("财务记账付款银行")
    private String finalPaymentBank;
    /** 财务记账付款账号 */
    @ApiModelProperty("财务记账付款账号")
    private String finalPaymentId;
    /** 财务记账记账科目 */
    @ApiModelProperty("财务记账记账科目")
    private Long finalAccountingSubject;
    /** 财务记账付款方式 */
    @ApiModelProperty("财务记账付款方式")
    private String finalPayMethod;
    /** 财务记账付款日期 */
    @ApiModelProperty("财务记账付款日期")
    private LocalDate finalPayDate;
    /** 财务记账备注 */
    @ApiModelProperty("财务记账备注")
    private String finalAccountingNote;
    /** 本次付款金额 */
    @ApiModelProperty("本次付款金额")
    private BigDecimal currPaymentAmt;
    /** 付款申请单记录 */
    @ApiModelProperty("付款申请单记录")
    private List<PaymentSlipPayload> paymentSlipPayloads;
    /** 费用承担部门 */
    @ApiModelProperty("费用承担部门")
    private List<CostUndertakeDepartmentPayload> costUndertakeDepartmentPayloads;
}
