package com.elitesland.tw.tw5.api.prd.purchase.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
  * 采购付款计划
  *
  * @author lipengfei
  * @date 2023-05-30
  */
@Getter
@Setter
public class PurchasePaymentPlanVO extends BaseViewModel implements Serializable {
    /** 付款阶段 */
    @ApiModelProperty("付款阶段")
    private String paymentStage;

    /** 付款金额 */
    @ApiModelProperty("付款金额")
    private BigDecimal paymentAmt;

    /** 本次付款金额 */
    @ApiModelProperty("本次付款金额")
    private BigDecimal currentPaymentAmt;

    /** 付款比例 */
    @ApiModelProperty("付款比例")
    private BigDecimal paymentProportion;

    /** 预计付款日期 */
    @ApiModelProperty("预计付款日期")
    private LocalDate estimatedPaymentDate;

    /** 付款申请单id */
    @ApiModelProperty("付款申请单Id")
    private Long paymentApplyId;

    /** 付款申请单号 */
    @ApiModelProperty("付款申请单号")
    private String paymentApplyNo;

    /**
     * 付款申请单类型
     */
    @ApiModelProperty("付款申请单类型")
    private String paymentApplicationType;
    @UdcName(udcName = "purchase:payment_type", codePropName = "paymentApplicationType")
    private String paymentApplicationTypeDesc;

    /**
     * 付款申请单状态
     */
    private String payApplyStatus;
    @UdcName(udcName = "purchase:payment_status", codePropName = "payApplyStatus")
    private String payApplyStatusName;

    /** 单据id */
    @ApiModelProperty("单据id")
    private Long contractId;

    /** 单据编号 */
    @ApiModelProperty("单据编号")
    private String contractNo;

    /** 付款状态 */
    @ApiModelProperty("付款状态")
    private String paymentStatus;
    @UdcName(udcName = "purchase:pay_status", codePropName = "paymentStatus")
    @ApiModelProperty("付款状态描述")
    private String paymentStatusDesc;

    /** 核销状态 */
    @ApiModelProperty("核销状态")
    private String writeoffStatus;

    /** 核销状态描述 */
    @ApiModelProperty("核销状态描述")
    private String writeoffStatusDesc;

    /** 约束里程碑 */
    @ApiModelProperty("约束里程碑")
    private Long milestone;

    /**  约束里程碑 名称 */
    @ApiModelProperty("约束里程碑名称")
    private String milestoneName;

    /** 单据类型 */
    @ApiModelProperty("单据类型")
    private String docType;

    /** 单据类型描述 */
    @UdcName(udcName = "purchase:doc_type", codePropName = "docType")
    @ApiModelProperty("单据类型描述")
    private String docTypeDesc;

    /** 付款时间 */
    @ApiModelProperty("付款时间")
    private LocalDateTime paymentDate;

    /** 约束合同节点 */
    @ApiModelProperty("约束合同节点")
    private Long contractNode;

    /**  约束合同节点 名称 */
    @ApiModelProperty("约束合同节点 名称")
    private String contractNodeName;

    /** 当期应收款金额 */
    @ApiModelProperty("当期应收款金额")
    private BigDecimal receAmt;

    /** 已收款金额 */
    @ApiModelProperty("已收款金额")
    private BigDecimal actualReceAmt;

    /** 合同收款计划状态（合同节点状态） */
    @ApiModelProperty("合同收款计划状态（合同节点状态）")
    private String receStatus;
    @UdcName(udcName = "salecon:payment_status", codePropName = "receStatus")
    private String receStatusDesc;

    /** 已核销金额 */
    @ApiModelProperty("已核销金额")
    private BigDecimal alreadyWriteOffAmt;

    /** 未核销金额 */
    @ApiModelProperty("未核销金额")
    private BigDecimal noWriteOffAmt;

    /** 预付款中付款计划id */
    private Long prePaymentPlanId;

    /** 付款日期 */
    private LocalDate payDate;

    /** 核销单 */
    @ApiModelProperty("核销单")
    private List<WriteOffPaymentApplyVO> writeOffAmtPaymentApplyVOS;

}
