package com.elitesland.tw.tw5.api.prd.salecon.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

/**
 * 业绩统计明细
 *
 * @author likunpeng
 * @date 2023-04-24
 */
@Getter
@Setter
public class ConAchieveDQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 业绩统计ID 精确
     */
    @ApiModelProperty("业绩统计ID")
    private Long achieveId;
    /**
     * 部门类别 精确
     */
    @ApiModelProperty("部门类别")
    private String buType;
    /**
     * 部门ID 精确
     */
    @ApiModelProperty("部门ID")
    private Long buId;
    /**
     * 业绩类别 精确
     */
    @ApiModelProperty("业绩类别")
    private String achieveType;

    /**
     * 业绩类别 精确
     */
    @ApiModelProperty("业绩类别")
    private List<String> achieveTypes;
    /**
     * 价值角色 精确
     */
    @ApiModelProperty("价值角色")
    private String valueRole;
    /**
     * 部门归属人员ID 精确
     */
    @ApiModelProperty("部门归属人员ID")
    private Long chargeResId;
    /**
     * 比例 精确
     */
    @ApiModelProperty("比例")
    private String ratio;
    /**
     * 金额 精确
     */
    @ApiModelProperty("金额")
    private BigDecimal amt;

    /**
     * 主合同编号/名称
     */
    @ApiModelProperty("主合同编号/名称")
    private String mainConCodeOrName;
    /**
     * 子合同编号/名称
     */
    @ApiModelProperty("子合同编号/名称")
    private String subConCodeOrName;
    /**
     * 签单年度
     */
    @ApiModelProperty("签单年度")
    private Long signYear;
    /**
     * 签单日期范围
     */
    @ApiModelProperty("签单日期范围")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> signDate;
    /**
     * 合同状态 第一个为：0：=，1：!=，第二个为合同状态
     */
    @ApiModelProperty("合同状态")
    private List<String> statusList = new ArrayList<>();
    /**
     * 客户ID
     */
    @ApiModelProperty("客户ID")
    private Long custId;

    /**
     * 组织id集合，用于列表权限
     */
    private List<Long> orgIdsByPermission;

    /**
     * 用户id集合，用于列表权限
     */
    private List<Long> userIdsByPermission;

}
