package com.elitesland.tw.tw5.api.prd.system.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)

public class PrdSystemRolePayload extends TwCommonPayload {
    /**
     * 角色编号
     */
    private String roleCode;
    /**
     * 角色名称
     */
    private String roleName;
    /**
     * 角色启用状态
     */
    private Boolean enabled;
    /**
     * 角色菜单ids  如果修改的时候传值是 “null”表示赋值菜单没有改变，如果是空数组“[]”表示把赋值菜单全部删除
     */
    private List<Long> menuIds;
    /**
     * 员工ids 如果修改的时候传值是 “null”表示赋值员工没有改变，如果是空数组“[]”表示把赋值员工全部删除
     */
    private List<Long> userIds;
    /**
     * 功能ids 如果修改的时候传值是 “null”表示赋值功能没有改变， 如果是空数组“[]”表示把赋值员工全部删除
     */
    private List<Long> functionIds;
    /**
     * 角色排序
     */
    private Integer sortIndex;
    /**
     * 角色组主键
     */
    private Long roleGroupId;

}
