package com.elitesland.tw.tw5.api.prd.system.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 业务对象字段明细
 *
 * @author duwh
 * @date 2023-06-14
 */
@Getter
@Setter
public class PrdSystemPermissionTableFieldsQuery extends TwQueryParam implements Serializable{
    /** 业务对象主表主键 prd_business_table.id */
    private Long tableId;
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 字段 精确 */
    @ApiModelProperty("字段")
    private String field;
    /** 字段类型(数据库) 精确 */
    @ApiModelProperty("字段类型(数据库)")
    private String type;
    /** 字段key 精确 */
    @ApiModelProperty("字段key")
    private String fieldKey;
    /** 字段名称 精确 */
    @ApiModelProperty("字段名称")
    private String fieldName;
    /** 是否业务字段 精确 */
    @ApiModelProperty("是否业务字段")
    private Boolean businessFlag;
    /** 是否必填 精确 */
    @ApiModelProperty("是否必填")
    private Boolean notNull;
    /** 显示名称 精确 */
    @ApiModelProperty("显示名称")
    private String showName;
    /** 业务类型 INPUT 文本输入 SELECT 选择器 精确 */
    @ApiModelProperty("业务类型 INPUT 文本输入 SELECT 选择器")
    private String showType;
    /** 业务属性 JSON格式 精确 */
    @ApiModelProperty("业务属性 JSON格式")
    private String showAttr;
    /** 默认值 精确 */
    @ApiModelProperty("默认值")
    private String defaultValue;
    /** 正则验证 精确 */
    @ApiModelProperty("正则验证")
    private String regexVerify;
    /** 排序号 精确 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 拓展字段1 精确 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 精确 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 精确 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
}
