package com.elitesland.tw.tw5.api.prd.visit.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.visit.payload.VisitSignRecordPayload;
import com.elitesland.tw.tw5.api.prd.visit.query.VisitSignRecordQuery;
import com.elitesland.tw.tw5.api.prd.visit.vo.VisitSignRecordVO;


import java.util.List;

/**
 * 销售拜访任务执行情况签到记录
 *
 * @author duwh
 * @date 2023-03-13
 */
public interface VisitSignRecordService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link VisitSignRecordVO}>
     */
    PagingVO<VisitSignRecordVO> paging(VisitSignRecordQuery query);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link VisitSignRecordVO}>
     */
    PagingVO<VisitSignRecordVO> queryPaging(VisitSignRecordQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link VisitSignRecordVO}>
     */
    List<VisitSignRecordVO> queryList(VisitSignRecordQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link VisitSignRecordVO}>
     */
    List<VisitSignRecordVO> queryListDynamic(VisitSignRecordQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link VisitSignRecordVO}
     */
    VisitSignRecordVO queryByKey(Long key);

    /**
    * 新增
    *
    * @param payload 单据数据
    * @return {@link VisitSignRecordVO}
    */
    VisitSignRecordVO insert(VisitSignRecordPayload payload);

    /**
    * 逻辑删除
    *
    * @param keys 主键集合
    */
    void deleteSoft(List<Long> keys);

}
