package com.elitesland.tw.tw5.api.common.funConfig.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeConfigAllowRolePayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeConfigAllowRoleQuery;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeConfigAllowRoleVO;

import java.util.List;

/**
 * 通用文档-文档类型访问权限
 *
 * @author duwh
 * @date 2023-12-10
 */
public interface BusinessDocTypeConfigAllowRoleService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessDocTypeConfigAllowRoleVO}>
     */
    PagingVO<BusinessDocTypeConfigAllowRoleVO> queryPaging(BusinessDocTypeConfigAllowRoleQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessDocTypeConfigAllowRoleVO}>
     */
    List<BusinessDocTypeConfigAllowRoleVO> queryListDynamic(BusinessDocTypeConfigAllowRoleQuery query);

    /**
     * 计数
     *
     * @param query 查询
     * @return {@link Long}
     */
    Long count(BusinessDocTypeConfigAllowRoleQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessDocTypeConfigAllowRoleVO}
     */
    BusinessDocTypeConfigAllowRoleVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessDocTypeConfigAllowRoleVO}
     */
    BusinessDocTypeConfigAllowRoleVO insert(BusinessDocTypeConfigAllowRolePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessDocTypeConfigAllowRoleVO}
     */
    BusinessDocTypeConfigAllowRoleVO update(BusinessDocTypeConfigAllowRolePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessDocTypeConfigAllowRolePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
