package com.elitesland.tw.tw5.api.prd.acc.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * 报销明细餐费记录
 *
 * @author zoey
 * @date 2024-06-12
 */
@Getter
@Setter
public class AccReimDetailMealQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 报销单明细ID 精确
     */
    @ApiModelProperty("报销单明细ID")
    private Long reimDetailId;
    /**
     * 打卡记录id 精确
     */
    @ApiModelProperty("打卡记录id")
    private Long attendanceId;

    /**
     * 打卡记录id 精确
     */
    @ApiModelProperty("打卡记录id")
    private List<Long> attendanceIds;
//    /**
//     * 法定假期id 精确
//     */
//    @ApiModelProperty("法定假期id")
//    private Integer vacationId;
    /**
     * 附件 精确
     */
    @ApiModelProperty("附件")
    private String fileCode;
    /**
     * 餐费日期 精确
     */
    @ApiModelProperty("餐费日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> mealDate;

    /**
     * 报销人
     */
    private Long userId;

    /**
     * 打卡城市
     */
    private String attendanceCity;
}
