package com.elitesland.tw.tw5.api.prd.acc.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSourceRecordPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSourceRecordQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSourceRecordVO;

import java.util.List;

/**
 * 报销金额来源记录管理
 *
 * @author sunxw
 * @date 2023-12-04
 */
public interface AccReimSourceRecordService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccReimSourceRecordVO}>
     */
    PagingVO<AccReimSourceRecordVO> queryPaging(AccReimSourceRecordQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccReimSourceRecordVO}>
     */
    List<AccReimSourceRecordVO> queryListDynamic(AccReimSourceRecordQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AccReimSourceRecordVO}
     */
    AccReimSourceRecordVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AccReimSourceRecordVO}
     */
    AccReimSourceRecordVO insert(AccReimSourceRecordPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AccReimSourceRecordVO}
     */
    AccReimSourceRecordVO update(AccReimSourceRecordPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AccReimSourceRecordPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据报销单id删除
     *
     * @param reimId
     */
    void delByReimId(Long reimId);

}
