package com.elitesland.tw.tw5.api.prd.cal.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 泛用金额结算管理
 *
 * @author carl
 * @date 2023-11-20
 */
@Getter
@Setter
public class CalNormSettlePayload extends TwCommonPayload implements Serializable {
    /**
     * 结算单号
     */
    @ApiModelProperty("结算单号")
    private String settleNo;
    /**
     * 结算状态
     */
    @ApiModelProperty("结算状态")
    private String settleStatus;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 流程实例id
     */
    @ApiModelProperty("流程实例id")
    private String procInstId;
    /**
     * 单据创建类型
     */
    @ApiModelProperty("单据创建类型")
    private String createType;
    /**
     * 业务类型
     */
    @ApiModelProperty("业务类型")
    private String busiType;
    /**
     * 相关业务单据号
     */
    @ApiModelProperty("相关业务单据号")
    private String relevNo;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDateTime applyDate;
    /**
     * 申请资源id
     */
    @ApiModelProperty("申请资源id")
    private Long applyResId;
    /**
     * 结算日期
     */
    @ApiModelProperty("结算日期")
    private LocalDate settleDate;
    /**
     * 财务期间id
     */
    @ApiModelProperty("财务期间id")
    private Long finPeriodId;
    /**
     * 子合同id
     */
    @ApiModelProperty("子合同id")
    private Long contractId;
    /**
     * 子合同名称（冗余）
     */
    @ApiModelProperty("子合同名称（冗余）")
    private String contractName;
    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 项目名称（冗余）
     */
    @ApiModelProperty("项目名称（冗余）")
    private String projName;
    /**
     * 任务id
     */
    @ApiModelProperty("任务id")
    private Long taskId;


    /**
     * 收入方账户（冗余）
     */
    @ApiModelProperty("收入方账户（冗余）")
    private String inAccount;
    /**
     * 收入方科目
     */
    @ApiModelProperty("收入方科目")
    private String inAcc;
    /**
     * 支出方账户
     */
    @ApiModelProperty("支出方账户（冗余）")
    private String outAccount;

    /**
     * 收入方账户id
     */
    @ApiModelProperty("收入方账户id")
    private Long inAccountId;

    /**
     * 支出方账户id
     */
    @ApiModelProperty("支出方账户id")
    private Long outAccountId;
    /**
     * 支出方科目
     */
    @ApiModelProperty("支出方科目")
    private String outAcc;
    /**
     * 实际结算总额
     */
    @ApiModelProperty("实际结算总额")
    private BigDecimal approveSettleAmt;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 申请人bu_id
     */
    @ApiModelProperty("申请人bu_id")
    private Long applyBuId;
    /**
     * 收款计划id
     */
    @ApiModelProperty("收款计划id")
    private Long recvplanId;

    /**
     * 收款阶段（冗余）
     */
    @ApiModelProperty("收款阶段（冗余）")
    private String receStage;
    /**
     * 是否提交 1：是，0或空：否
     */
    @ApiModelProperty("是否提交 1：是，0或空：否")
    private Integer isSubmit;
    /**
     * 收款计划编号
     */
    @ApiModelProperty("收款计划编号")
    private String recvplanNo;
    /**
     * 合同编号
     */
    @ApiModelProperty("合同编号")
    private String contractNo;
}
