package com.elitesland.tw.tw5.api.prd.my.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 工时-工作计划
 *
 * @author duwh
 * @date 2022-12-09
 */
@Data
public class TimesheetPlanVO extends BaseViewModel {
    /**
     * 填报用户id
     */
    private Long tsUserId;
    /**
     * 状态
     */
    private String tsStatus;
    /**
     * 类型
     */
    private String type;
    /** 审批用户id */
    //private Long apprUserId;
    /**
     * 客户经营计划主键
     */
    private Long operPlanId;
    /**
     * 客户经营计划名称冗余
     */
    private String operPlanName;
    /**
     * 项目id
     */
    private Long projId;
    /**
     * 项目编号冗余
     */
    private String projNo;
    /**
     * 项目名称
     */
    private String projName;
    @ApiModelProperty("事由id")
    private Long reasonId;
    @ApiModelProperty("事由名称")
    private String reasonName;
    @ApiModelProperty("事由类型 01 项目 02 售前 03 bu")
    private String reasonType;
    /** 任务包id */
    private Long taskPackageId;
    /** 任务包编号 冗余 */
    private String taskPackageNo;
    /** 任务包名称冗余 */
    private String taskPackageName;
    /**
     * 任务id
     */
    private Long taskId;
    /**
     * 任务编号冗余
     */
    private String taskNo;
    /**
     * 任务名称冗余
     */
    private String taskName;
    /**
     * 任务包申请状态
     */
    private String taskApplyStatus;
    /**
     * 活动id
     */
    private Long actId;
    /**
     * 活动名称冗余
     */
    private String actName;
    /**
     * 活动编号冗余
     */
    private String actNo;
    /**
     * 当量
     */
    private BigDecimal eqva;
    /**
     * 11上午、22下午、33全天、44自定义
     */
    private String workType;
    /**
     * 工作日期
     */
    private LocalDate workDate;
    /**
     * 工时
     */
    private BigDecimal workHour;
    /**
     * 工作说明
     */
    private String workDesc;
    /**
     * 本周开始日期
     */
    private LocalDate weekStartDate;
    /**
     * 所在年周
     */
    private Integer yearWeek;
    /**
     * 审批状态
     */
    private String apprStatus;
    /**
     * 任务标识
     */
    private String tsTaskIden;
    @UdcName(udcName = "prd:timesheet:taskType", codePropName = "tsTaskIden")
    private String tsTaskIdenDesc;
    /**
     * 活动标识
     */
    private String tsActIden;
    @UdcName(udcName = "prd:timesheet:actType", codePropName = "tsActIden")
    private String tsActIdenDesc;
    /**
     * 结算状态
     */
    private String settleStatus;
    /** 审批状态 */
    //private String apprResult;
    /** 是否加班、udc >> yesno */
    //private String workFlag;
    /** 可生成调休天数 */
    //private Float workDayOff;
    /** 相关加班安排id */
    //private Integer workRelId;
    /** 可生成调休天数的状态 */
    //private String workDayOffStatus;
    /** 审批时间 */
    //private LocalDateTime approvalTime;
    /** 提交时间 */
    //private LocalDateTime submitTime;
    /** 是否是系统自动生成，0：否，1：是 */
    //private Integer autoSaveFlag;
    /** 请假流程覆盖已填写工时标记 默认0 已覆盖拆分 1 */
    //private Integer autoUpdateFlag;
    /** 流程实例id */
    //private String procId;
    /**
     * 拓展1
     */
    private String ext1;
    /**
     * 拓展2
     */
    private String ext2;
    /**
     * 拓展3
     */
    private String ext3;
    /**
     * 拓展4
     */
    private String ext4;
    /**
     * 拓展5
     */
    private String ext5;

    /**
     * 标签
     **/
    private String label;

    private Long overtimeId;
}
