package com.elitesland.tw.tw5.api.prd.org.service;

import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgCompanyNoticePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgCompanyNoticeQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgCompanyNoticeVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

public interface PrdOrgCompanyNoticeService {
    /**
     * 新建
     *
     * @param payload
     * @return
     */
    PrdOrgCompanyNoticeVO insert(PrdOrgCompanyNoticePayload payload);

    /**
     * 修改
     *
     * @param payload
     * @return
     */
    PrdOrgCompanyNoticeVO update(PrdOrgCompanyNoticePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    PrdOrgCompanyNoticeVO queryByKey(Long key);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<PrdOrgCompanyNoticeVO> paging(PrdOrgCompanyNoticeQuery query);

    /**
     * 发布
     *
     * @param keys
     * @return
     */
    Boolean publish(List<Long> keys);

    /**
     * 发布
     *
     * @param keys
     * @return
     */
    Boolean revoke(List<Long> keys);

    /**
     * 列表查询
     *
     * @param query
     * @return
     */
    List<PrdOrgCompanyNoticeVO> queryList(PrdOrgCompanyNoticeQuery query);

    /**
     * 处理公告中的定时任务
     *
     * @param param
     */
    void companyNoticeJobHandler(String param);
}
