package com.elitesland.tw.tw5.api.prd.partner.common.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
/**
 * 业务伙伴管理-客户下拉查询
 *
 * @author wangluyu
 * @date 2023-12-04
 */
@Getter
@Setter
public class BusinessPartnerListSimpleQuery  extends TwQueryParam implements Serializable {
    /**
     * 业务伙伴身份 udc[CRM:BUSINESS_PARTNER:IDENTITY] 精确
     */
    @ApiModelProperty("业务伙伴身份 udc[CRM:BUSINESS_PARTNER:IDENTITY]")
    private String partnerIdentity;

    /**
     * 状态(客户 供应商等状态)
     */
    @ApiModelProperty("状态")
    private String customerStatus;

    /**
     * 业务伙伴名称 精确
     */
    @ApiModelProperty("业务伙伴名称")
    private String partnerName;
}
