package com.elitesland.tw.tw5.api.prd.partner.strategy.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyModelPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyModelQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessModelIndexVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyModelVO;

import java.util.List;

/**
 * 分级策略模型配置
 *
 * @author wangly
 * @date 2023-06-19
 */
public interface BusinessStrategyModelService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessStrategyModelVO}>
     */
    PagingVO<BusinessStrategyModelVO> queryPaging(BusinessStrategyModelQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessStrategyModelVO}>
     */
    List<BusinessStrategyModelVO> queryListDynamic(BusinessStrategyModelQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessStrategyModelVO}
     */
    BusinessStrategyModelVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessStrategyModelVO}
     */
    BusinessStrategyModelVO save(BusinessStrategyModelPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessStrategyModelVO}
     */
    BusinessStrategyModelVO update(BusinessStrategyModelPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessStrategyModelPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 通过时间范围参数查询rfm配置
     *
     * @param dateKey 近一年/近半年
     */
    List<BusinessModelIndexVO> findRfmSettingByDate(String dateKey);


    /**
     * 通过模型id查询对应的策略数量
     *
     * @param modelIdList 模型id business_strategy_model.id
     * @param strategyStatus 策略状态
     */
    Long queryStrategyByModelIdsAndStrategyStatus(List<Long>  modelIdList,String strategyStatus);


    /**
     * 校验是否关联分级策略
     *
     * @param modelId 模型id business_strategy_model.id
     */
    Boolean checkAssociationStrategy(Long modelId);
}
