package com.elitesland.tw.tw5.api.prd.product.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
    import java.time.LocalDate;
import java.math.BigDecimal;

/**
 * 产品管理
 *
 * @author likunpeng
 * @date 2023-05-22
 */
@Getter
@Setter
public class PrdProductQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 产品编号 模糊 */
    @ApiModelProperty("产品编号")
    private String prodNo;
    /** 产品名称 模糊 */
    @ApiModelProperty("产品名称")
    private String prodName;
    /** 产品大类;	表id，非udc 精确 */
    @ApiModelProperty("产品大类;	表id，非udc")
    private Long classId;
    /** 产品小类 精确 */
    @ApiModelProperty("产品小类")
    private Long subClassId;
    /** 税率 精确 */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /** 排序号 精确 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 供应主体类别 精确 */
    @ApiModelProperty("供应主体类别")
    private String prodType;
    /** BUID 精确 */
    @ApiModelProperty("BUID")
    private Long buId;
    /** 产品负责人资源ID 精确 */
    @ApiModelProperty("产品负责人资源ID")
    private Long picResId;
    /** 产品供应商ID 精确 */
    @ApiModelProperty("产品供应商ID")
    private Long coopId;
    /** 状态 精确 */
    @ApiModelProperty("状态")
    private String prodStatus;
    /** 适用行业 精确 */
    @ApiModelProperty("适用行业")
    private String industry;
    /** 参考当量 精确 */
    @ApiModelProperty("参考当量")
    private String refEqva;
    /** 参考价格 精确 */
    @ApiModelProperty("参考价格")
    private String refPrice;
    /** 是否考察中 精确 */
    @ApiModelProperty("是否考察中")
    private String inspectFlag;
    /** 考察原因描述 精确 */
    @ApiModelProperty("考察原因描述")
    private String inspectReason;
    /** 标签 精确 */
    @ApiModelProperty("标签")
    private String tagDesc;
    /** 提成类别 精确 */
    @ApiModelProperty("提成类别")
    private String royaltyType;
    /** LOGO路径 精确 */
    @ApiModelProperty("LOGO路径")
    private String logoPath;
    /** 视频路径 精确 */
    @ApiModelProperty("视频路径")
    private String videoPath;
    /** 软著名称 精确 */
    @ApiModelProperty("软著名称")
    private String copyrightName;
    /** 软著编号 精确 */
    @ApiModelProperty("软著编号")
    private String copyrightCode;
    /** 软著附件 精确 */
    @ApiModelProperty("软著附件")
    private String copyrightFileCodes;
    /** 是否有测试报告 精确 */
    @ApiModelProperty("是否有测试报告")
    private String reportFlag;
    /** 测试报告附件 精确 */
    @ApiModelProperty("测试报告附件")
    private String reportFileCodes;
    /** 是否有软件产品登记证 精确 */
    @ApiModelProperty("是否有软件产品登记证")
    private String sprcFlag;
    /** 软件产品登记证名称 精确 */
    @ApiModelProperty("软件产品登记证名称")
    private String sprcName;
    /** 件产品登记证编号 精确 */
    @ApiModelProperty("软件产品登记证编号")
    private String sprcCode;
    /** 软著附件 精确 */
    @ApiModelProperty("软件产品登记证附件")
    private String sprcFileCodes;
    /** 软件产品登记证书有效日期开始 精确 */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("软件产品登记证书有效日期开始")
    private LocalDate startDate;
    /** 软件产品登记证书有效日期开始 精确 */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("软件产品登记证书有效日期结束")
    private LocalDate endDate;
    /** 产品简介 精确 */
    @ApiModelProperty("产品简介")
    private String prodDesc;
    /** 功能模块 精确 */
    @ApiModelProperty("功能模块")
    private String functionDesc;
    /** 目标客户 精确 */
    @ApiModelProperty("目标客户")
    private String customerDesc;
}
