package com.elitesland.tw.tw5.api.prd.salecon.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 销售合同
 *
 * @author danting
 * @date 2023-03-30
 */
@Data
@ExcelIgnoreUnannotated
public class SaleConContractListVO extends BaseViewModel implements Serializable {

    /**
     * 合同编号
     */
    @ApiModelProperty("合同编号")
    @ExcelProperty(index = 0, value = "合同编号")
    private String code;
    /**
     * 合同名称
     */
    @ApiModelProperty("合同名称")
    @ExcelProperty(index = 1, value = "合同名称")
    private String name;
    /**
     * 合同状态
     */
    @ApiModelProperty("合同状态")
    private String status;

    /**
     * 商机id
     */
    @ApiModelProperty("商机id")
    private Long oppoId;
    @ApiModelProperty("合同总金额")
    private BigDecimal amt;

    @ApiModelProperty("工作类型")
    private String workType;

    @ApiModelProperty("有效合同金额")
    private BigDecimal effectiveAmt;

    /**
     * 销售负责人
     */
    @ApiModelProperty("销售负责人")
    private Long saleManUserId;
    @UdcName(udcName = "USER", codePropName = "saleManUserId")
    private String saleManUserName;
}
