package com.elitesland.tw.tw5.api.prd.task.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;


/**
 * 任务结算工时关系表
 *
 * @author carl
 * @date 2023-12-20
 */
@Getter
@Setter
public class TaskSettleTimesheetVO extends BaseViewModel implements Serializable {
    /**
     * 任务id
     */
    @ApiModelProperty("任务id")
    private Long taskId;
    @ApiModelProperty("任务名称")
    private String taskName;
    /**
     * 结算id
     */
    @ApiModelProperty("结算id")
    private Long settleId;
    /**
     * 工时id
     */
    @ApiModelProperty("工时id")
    private Long timesheetId;

    @ApiModelProperty("关联活动")
    private Long relatedActId;
    /**
     * 工时
     */
    @ApiModelProperty("工时")
    private BigDecimal workHour;
    /**
     * 当量
     */
    @ApiModelProperty("当量")
    private BigDecimal eqva;
    /**
     * 工作日期
     */
    @ApiModelProperty("工作日期")
    private LocalDate workDate;
    /**
     * 工作日志
     */
    @ApiModelProperty("工作日志")
    private String workDesc;
    /**
     * 工时任务结算流转标记（后改的，结构不好动所以命名和值定义不太合理）：-1或null已提交，0已审批，1已结算
     */
    @ApiModelProperty("工时任务结算流转标记（后改的，结构不好动所以命名和值定义不太合理）：-1或null已提交，0已审批，1已结算")
    private Integer settleFlag;
    @ApiModelProperty("工时填报人ID")
    private Long tsUserId;
    @UdcName(udcName = "USER", codePropName = "tsUserId")
    private String tsUserName;

    @ApiModelProperty("事由id")
    private Long reasonId;
    @ApiModelProperty("事由名称")
    private String reasonName;
    @ApiModelProperty("事由类型 01 项目 02 售前 03 bu")
    private String reasonType;
    @UdcName(udcName = "PMS:PROJECT:TYPE", codePropName = "reasonType")
    private String reasonTypeDesc;
}
